//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { MockMethod } from 'vite-plugin-mock';
import { spData } from './data/sp.data';
import { ibmaData } from './data/ibma.data';
import networkModule from './network/network';
import { genericInfo } from './data/generic.data';
import { reqPath } from '@/api/reqPath';
import { LanguageData } from './data/language.data';
import { usbData } from './data/usb.data';

export default [
  {
    url: reqPath.manager.sp,
    method: 'get',
    timeout: 500,
    response: spData
  },
  {
    url: reqPath.manager.ibma.getIbmaData,
    method: 'get',
    timeout: 500,
    response: ibmaData
  },
  {
    url: reqPath.manager.ibma.usbStickControl,
    method: 'post',
    timeout: 500,
    response: ''
  },
  {
    url: reqPath.manager.exportConfig.genericInfo,
    method: 'get',
    timeout: 500,
    response: genericInfo
  },
  {
    url: '/UI/Rest/BMCSettings/Language',
    method: 'get',
    timeout: 500,
    response: LanguageData
  },
  { url: reqPath.manager.usb, method: 'get', timeout: 500, response: usbData },
  ...networkModule
] as MockMethod[];
