//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { MockMethod } from 'vite-plugin-mock';
import { systemDiagnosticData, processorData } from './data/index';
import { reqPath } from '@/api/reqPath';

export default [
  {
    url: reqPath.maintance.systemlog.systemDiagnostic,
    method: 'get',
    timeout: 500,
    response: systemDiagnosticData
  },
  {
    url: reqPath.maintance.systemlog.systemDiagnostic,
    method: 'patch',
    timeout: 500,
    response: ''
  },
  {
    url: reqPath.maintance.systemlog.processor,
    method: 'get',
    timeout: 500,
    response: processorData
  },
  // 点击 黑匣子功能 对应的 下载，返回对应的下载地址
  {
    url: reqPath.maintance.systemlog.downloadBlackBox,
    method: 'post',
    timeout: 500,
    response: {
      url: reqPath.maintance.systemlog.downloadBlackBoxResUrl
    }
  },
  // 下载 黑匣子功能 数据
  {
    url: reqPath.maintance.systemlog.downloadBlackBoxResUrl,
    method: 'get',
    timeout: 500,
    response: ''
  },
  // 点击 系统串口数据记录功能 对应的 下载，返回对应的下载地址
  {
    url: reqPath.maintance.systemlog.downloadSerialPortData,
    method: 'post',
    timeout: 500,
    response: {
      url: reqPath.maintance.systemlog.DownloadSerialPortDataResUrl
    }
  },
  // 下载 系统串口数据记录功能 数据
  {
    url: reqPath.maintance.systemlog.DownloadSerialPortDataResUrl,
    method: 'get',
    timeout: 500,
    response: ''
  },
  // 点击 NPU日志 对应的 下载，返回对应的下载地址
  {
    url: reqPath.maintance.systemlog.downloadNpuLog,
    method: 'post',
    timeout: 500,
    response: {
      url: reqPath.maintance.systemlog.downloadNpuLogResUrl
    }
  },
  // 下载 NPU日志 数据
  {
    url: reqPath.maintance.systemlog.downloadNpuLogResUrl,
    method: 'get',
    timeout: 500,
    response: ''
  }
] as MockMethod[];
