//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.

import vue from '@vitejs/plugin-vue';
import path from 'path';
import AutoImport from 'unplugin-auto-import/vite';
import viteVueComponents from 'unplugin-vue-components/vite';
import { ElementPlusResolver } from 'unplugin-vue-components/resolvers';
import { OpenDesignResolver } from '@computing/opendesign2/themes/plugins/resolver';
import viteSvgIconsPlugin from 'vite-plugin-svg-icons';
import { configMock } from './mock';
import basicSsl from '@vitejs/plugin-basic-ssl';

export function loadVitePlugins(configs: any) {
  const { VITE_USE_MOCK, VITE_BUNDLE_VISUAL } = configs;

  const plugins = [
    vue(),
    basicSsl(),
    AutoImport({
      resolvers: [OpenDesignResolver(ElementPlusResolver, { importStyle: 'sass' })],
      dts: path.resolve('', 'auto-imports.d.ts'),
    }),
    viteVueComponents({
      resolvers: [OpenDesignResolver(ElementPlusResolver, { importStyle: 'sass' })],
      dts: path.resolve('', 'components.d.ts'),
    }),
    viteSvgIconsPlugin({
      iconDirs: [path.resolve('src/assets/svgIcons')],
      symbolId: 'icon-[dir]-[name]'
    }),
  ];

  if (VITE_USE_MOCK) {
    plugins.push(configMock());
  }

  return plugins;
}