module.exports = {
  root: true,
  env: {
    browser: true, // browser global variables
    es2021: true, // adds all ECMAScript 2021 globals and automatically sets the ecmaVersion parser option to 12.
  },
  plugins: ['@typescript-eslint'],
  extends: ['plugin:vue/vue3-recommended'],
  parser: 'vue-eslint-parser',
  parserOptions: {
    ecmaVersion: 12,
    parser: '@typescript-eslint/parser',
  },
  globals: {
    window: 'readonly',
    document: 'readonly',
    location: 'readonly',
    define: 'readonly',
    navigator: 'readonly',
    JSON: 'readonly',
    require: 'readonly',
    sessionStorage: 'readonly',
    localStorage: 'readonly',
    Blob: 'readonly',
    module: 'readonly',
  },
  rules: {
    'vue/multi-word-component-names': 0,
    'vue/html-indent': ['error', 2],
    'vue/max-attributes-per-line': ['error',
      {
        singleline: 4,
        multiline: 4,
      },
    ],
    'vue/singleline-html-element-content-newline': 0,
    'vue/html-self-closing': 0,
    indent: ['error', 2, { SwitchCase: 1 }],
    '@typescript-eslint/indent': ['error', 2],
    'no-mixed-spaces-and-tabs': 'error',
    'new-cap': 'error',
    'camelcase': 'error',
    'spaced-comment': ['error', 'always'],
    'no-warning-comments': ['error', { terms: ['todo', 'fixme', 'fixing'], location: 'anywhere' }],
    'max-len': ['error', { code: 120 }],
    'keyword-spacing': ['error', { before: true }],
    'no-var': 'off',
    // 禁止使用eval()
    'no-eval': 'error',
    // 禁止使用with() {}
    'no-with': 'error',
    // 方法设计的第一原则是要短小，根据业界经验，方法的长度建议不超过50行
    'max-lines-per-function': ['error', 50],
    // 圈复杂度不超过15
    complexity: ['error', 15],
    // 块语句的最大可嵌套深度不要超过4层
    'max-depth': ['error', 4],
    // 建议字符串使用单引号
    quotes: [2, 'single'],
    // 判断相等时使用 === 和 !== ，而不是 == 和 !=
    eqeqeq: 'warn',
    // 在switch语句的每一个case中都放置一条break语句
    'default-case': 'error',
    // 拖尾逗号
    'comma-dangle': ['error', 'always-multiline']
  },
};
