-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local FAN_BOARD_INTERFACE <const> = "bmc.kepler.Systems.Board"

TestFanBoard = {}

function TestFanBoard:test_get_total_power_watts()
    local fan_board_data_keeping = require 'basic_cooling.data_keeping.fan_board_data_keeping'

    local total_power_watts = fan_board_data_keeping:get_total_power_watts()
    lu.assertEquals(total_power_watts, nil)

    local fan_board_path1 = "/bmc/kepler/Systems/1/Boards/FanBoard/FanBoard_1_01"
    local fan_board_path2 = "/bmc/kepler/Systems/1/Boards/FanBoard/FanBoard_1_02"
    fan_board_data_keeping.objs = {
        [fan_board_path1] = {
            [FAN_BOARD_INTERFACE] = {
                obj = {
                    ['PowerWatts'] = 100
                }
            }
        },
        [fan_board_path2] = {
            [FAN_BOARD_INTERFACE] = {
                obj = {
                    ['PowerWatts'] = 200
                }
            }
        }
    }

    total_power_watts = fan_board_data_keeping:get_total_power_watts()
    lu.assertEquals(total_power_watts, 300)
end