-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'

TestFanService = {}

function TestFanService:test_get_dump_pwm_by_fan_obj()
    local fan_service = require 'fan_service'
    local fan_obj1 = {
        HardwarePWM = 66,
        PowerGood = 1,
        standbyfan = false
    }
    local fan_obj2 = {
        HardwarePWM = 66,
        PowerGood = 0,
        standbyfan = true
    }
    local fan_obj3 = {
        HardwarePWM = 66,
        PowerGood = 0,
        standbyfan = false
    }

    local pwm = fan_service.get_dump_pwm_by_fan_obj(fan_obj1)
    lu.assertEquals(pwm, 66)
    pwm = fan_service.get_dump_pwm_by_fan_obj(fan_obj2)
    lu.assertEquals(pwm, 66)
    pwm = fan_service.get_dump_pwm_by_fan_obj(fan_obj3)
    lu.assertEquals(pwm, 0)
end