-- Copyright (c) Huawei Technologies Co., Ltd. 2024. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
require 'skynet.manager'
local error = require 'mc.error'
local safe_call = error.safe_call
local mdb = require 'mc.mdb'
local skynet = require 'skynet'

local test_special_rpc = {}

-- 获取必要的风扇代理对象
local function l_objs_init(bus)
    local ok
    local req_7_obj, req_25_obj, t_fan_1_obj, t_fan_2_obj
    local cooling_config_fans_obj
    local c_req_7_path = '/bmc/kepler/Systems/1/CoolingRequirement/CoolingRequirement_1_7_0101'
    local c_req_25_path = '/bmc/kepler/Systems/1/CoolingRequirement/CoolingRequirement_1_25_0101'
    local t_fan_1_path = '/bmc/kepler/Systems/1/Thermal/Fans/Fan_1_0101'
    local t_fan_2_path = '/bmc/kepler/Systems/1/Thermal/Fans/Fan_2_0101'
    local cooling_config_fans_path = '/bmc/kepler/Systems/1/AirCoolingConfig'
    ok, req_7_obj = pcall(mdb.get_object, bus, c_req_7_path, 'bmc.kepler.Systems.CoolingRequirement')
    assert(ok)

    ok, req_25_obj = pcall(mdb.get_object, bus, c_req_25_path, 'bmc.kepler.Systems.CoolingRequirement')
    assert(ok)

    ok, cooling_config_fans_obj = pcall(mdb.get_object, bus, cooling_config_fans_path, 'bmc.kepler.Systems.FanSnapshot')
    assert(ok)

    ok, t_fan_1_obj = pcall(mdb.get_object, bus, t_fan_1_path, 'bmc.kepler.Systems.Fan')
    assert(ok)

    ok, t_fan_2_obj = pcall(mdb.get_object, bus, t_fan_2_path, 'bmc.kepler.Systems.Fan')
    assert(ok)

    return {
        ['req_7_obj'] = req_7_obj,
        ['req_25_obj'] = req_25_obj,
        ['cooling_config_fans_obj'] = cooling_config_fans_obj,
        ['t_fan_1'] = t_fan_1_obj,
        ['t_fan_2'] = t_fan_2_obj
    }
end

local function test_get_fansnap_shot(req_7_obj, req_25_obj, cooling_config_fans_obj, fan_1, fan_2, ctx_new)
    fan_1.RearSpeed = 60
    skynet.sleep(2000) -- 等待转速响应
    local err, rsp = safe_call(cooling_config_fans_obj.GetActivatedPolicyFactors_PACKED,
        cooling_config_fans_obj, ctx_new)
    assert(not err)
    assert(rsp.RetData.FactorName == 'Outlet Temp', 'Actual: ' .. rsp.RetData.FactorName)
    assert(rsp.RetData.ActivatedType == 0, 'Actual: ' .. rsp.RetData.ActivatedType)
    fan_1.RearSpeed = 20 -- 恢复配置值
    skynet.sleep(2000) -- 等待转速响应
    fan_2.RearSpeed = 60
    skynet.sleep(2000) -- 等待转速响应
    err, rsp = safe_call(cooling_config_fans_obj.GetActivatedPolicyFactors_PACKED,
        cooling_config_fans_obj, ctx_new)
    assert(not err)
    assert(rsp.RetData.FactorName == 'PSU1 Temp',  'Actual: ' .. rsp.RetData.FactorName)
    assert(rsp.RetData.ActivatedType == 0, 'Actual: ' .. rsp.RetData.ActivatedType)
    fan_2.RearSpeed = 0 -- 恢复配置值
    skynet.sleep(2000) -- 等待10s使转速下降
end

function test_special_rpc.main(bus, ctx_new)
    log:notice('================ test special rpc start ================')
    local l_objs = l_objs_init(bus)
    test_get_fansnap_shot(l_objs.req_7_obj, l_objs.req_25_obj, l_objs.cooling_config_fans_obj, l_objs.t_fan_1,
        l_objs.t_fan_2, ctx_new)

    log:notice('================ test special rpc complete ================')
end

return test_special_rpc