-- Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
require 'skynet.manager'
local cooling_enums = require 'basic_cooling.define.cooling_enums'

local test_pumps_config = {}

local function test_SetCtrlMode(ctx_new,pumps_config)
    local ok= pcall(pumps_config.SetCtrlMode, pumps_config, ctx_new, cooling_enums.modes.Manual, 0)
    assert(ok)
    ok= pcall(pumps_config.SetCtrlMode, pumps_config, ctx_new, 'nomode', 100)
    assert(not ok)
    ok= pcall(pumps_config.SetCtrlMode, pumps_config, ctx_new, cooling_enums.modes.Auto, 0)
    assert(ok)
    ok= pcall(pumps_config.SetCtrlMode, pumps_config, ctx_new, cooling_enums.modes.Auto, 100000001)
    assert(not ok)
end

local function test_SetManualLevel(ctx_new,pumps_config)
    local ok = pcall(pumps_config.SetManualLevel, pumps_config, ctx_new, 0xff, 100)
    assert(ok)
    ok= pcall(pumps_config.SetManualLevel, pumps_config, ctx_new, 1, 30)
    assert(ok)
end

function test_pumps_config.main(bus, ctx_new, pumps_config, c_pump_1, c_pump_2)
    log:info('================ test pumps config start ================')
    test_SetCtrlMode(ctx_new,pumps_config)
    test_SetManualLevel(ctx_new,pumps_config)
    log:info('================ test pumps config complete ================')
end

return test_pumps_config