-- Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local skynet = require 'skynet'
local log = require 'mc.logging'
local mdb = require 'mc.mdb'
require 'skynet.manager'
require 'thermal_mgmt.json_types.CoolingRequirement'
local enums = require 'basic_cooling.define.cooling_enums'
local props = require 'basic_cooling.define.cooling_properties'
local error = require 'mc.error'

local test_cooling_job = {}

-- 获取必要的风扇代理对象
local function l_objs_init(bus)
    local ok
    local c_req_6_obj, c_req_7_obj

    local c_req_6_path = '/bmc/kepler/Systems/1/CoolingRequirement/CoolingRequirement_1_6_0101'
    local c_req_7_path = '/bmc/kepler/Systems/1/CoolingRequirement/CoolingRequirement_1_7_0101'

    ok, c_req_6_obj = pcall(mdb.get_object, bus, c_req_6_path, 'bmc.kepler.Systems.CoolingRequirement')
    assert(ok)
    ok, c_req_7_obj = pcall(mdb.get_object, bus, c_req_7_path, 'bmc.kepler.Systems.CoolingRequirement')
    assert(ok)

    return {
        ['c_fan_6'] = c_req_6_obj,
        ['c_fan_7'] = c_req_7_obj,
    }
end

function test_cooling_job.main(bus, conf_o, ctx_new)
    log:info('================ test cooling job start ================')
    local l_objs = l_objs_init(bus)
    local smart_cooling_mode_bck = conf_o[props.SMART_COOLING_MODE]

    conf_o:SetSmartCoolingMode_PACKED(ctx_new, enums.smart_cooling_mode.COOLING_HIGH_PERFORMANCE_MODE)
    assert(conf_o[props.SMART_COOLING_MODE] == enums.smart_cooling_mode.COOLING_HIGH_PERFORMANCE_MODE)
    skynet.sleep(1000)
    assert(l_objs['c_fan_7'].TargetTemperatureCelsius == 42,
        'TargetTemperatureCelsius:' .. tostring(l_objs['c_fan_7'].TargetTemperatureCelsius))

    conf_o:SetSmartCoolingMode_PACKED(ctx_new, enums.smart_cooling_mode.COOLING_LOW_NOISE_MODE)
    assert(conf_o[props.SMART_COOLING_MODE] == enums.smart_cooling_mode.COOLING_LOW_NOISE_MODE)
    skynet.sleep(1000)
    assert(l_objs['c_fan_7'].TargetTemperatureCelsius == 48)

    conf_o:SetSmartCoolingMode_PACKED(ctx_new, smart_cooling_mode_bck)
    log:info('================ test cooling job complete ================')
end

return test_cooling_job
