-- Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local skynet = require 'skynet'
local log = require 'mc.logging'
local mdb = require 'mc.mdb'
require 'skynet.manager'
require 'thermal_mgmt.json_types.CoolingRequirement'

local test_conflict_requirement_obj = {}

-- 获取必要的风扇代理对象
local function l_objs_init(bus)
    local ok
    local c_req_76_1_obj, c_req_76_2_obj, c_req_76_3_obj

    local c_req_76_1_path = '/bmc/kepler/Systems/1/CoolingRequirement/CoolingRequirement_1_76_1_0101'
    local c_req_76_2_path = '/bmc/kepler/Systems/1/CoolingRequirement/CoolingRequirement_1_76_2_0101'
    local c_req_76_3_path = '/bmc/kepler/Systems/1/CoolingRequirement/CoolingRequirement_1_76_3_0101'

    ok, c_req_76_1_obj = pcall(mdb.get_object, bus, c_req_76_1_path, 'bmc.kepler.Systems.CoolingRequirement')
    assert(ok)
    ok, c_req_76_2_obj = pcall(mdb.get_object, bus, c_req_76_2_path, 'bmc.kepler.Systems.CoolingRequirement')
    assert(ok)
    ok, c_req_76_3_obj = pcall(mdb.get_object, bus, c_req_76_3_path, 'bmc.kepler.Systems.CoolingRequirement')
    assert(ok)

    return {
        ['c_req_76_1_obj'] = c_req_76_1_obj,
        ['c_req_76_2_obj'] = c_req_76_2_obj,
        ['c_req_76_3_obj'] = c_req_76_3_obj
    }
end

function test_conflict_requirement_obj.main(bus)
    log:info('================ test conflict requirement obj start ================')
    local l_objs = l_objs_init(bus)
    assert(l_objs['c_req_76_1_obj'].RequirementId ~= l_objs['c_req_76_2_obj'].RequirementId)
    assert(l_objs['c_req_76_2_obj'].RequirementId ~= l_objs['c_req_76_3_obj'].RequirementId)
    assert(l_objs['c_req_76_1_obj'].RequirementId ~= l_objs['c_req_76_3_obj'].RequirementId)
    log:info('================ test conflict requirement obj end ================')
end

return test_conflict_requirement_obj