-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'

local boot_loader = {}
local env_map = {['copBootSize'] = '0x1000000'}
local env_support = {['copBootSize'] = true}
setmetatable(boot_loader, {
    __close = function()
    end
})

function boot_loader.new()
    return boot_loader
end

function boot_loader:get_pcie_controller_state(id)
    lu.assertEquals(id, 1)
    return self.state
end

function boot_loader:set_pcie_controller_state(id, state)
    lu.assertEquals(id, 1)
    self.state = state
end

function boot_loader:get_uboot_env(name)
    if not env_support[name] then
        error(string.format('env %s is not supported', name))
    end
    return tonumber(env_map[name])
end

function boot_loader:set_uboot_env(name, value)
    if not env_support[name] then
        error(string.format('env %s is not supported', name))
    end

    if type(value) ~= 'string' or not value:match('^0x[A-Fa-f0-9]+$') then
        error(string.format('invalid format'))
    end
    env_map[name] = value
end

function boot_loader:close()
end

return boot_loader