-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local usb = {}

function usb:new()
    return usb
end

function usb:usb_compound_connect(usb_id, fn_list)
    log:info('usb driver is connecting device: usb_id=%d, fn_cnt=%d, fn_list=%s', usb_id, #fn_list,
        table.concat(fn_list, ' '))
    return {0, 1, 2, 3} -- 模拟驱动数据
end

function usb:usb_compound_disconnect(usb_id)
    log:info('usb driver is disconnecting device: usb_id=%d', usb_id)
end

function usb:usb_compound_state_get(usb_id, fn_id)
    return 1 -- 模拟usb设备状态
end

return usb