-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local sol = {}

function sol:new()
    return sol
end

function sol:close()
end

function sol:enable(status)
    local index = (status >> 1) & 0x07
    local enable = status & 0x01
    log:info('set uart:%s log enable:%s', index, enable)
end

function sol:read(direction, index, length)
    if direction ~= 0 or direction ~= 1 then
        return
    end
    if index < 0 or index > 3 then
        return
    end
    log:info('read uart:%s log length:%s', index, length)
    return string.rep('S', length)
end

function sol:get_pos(pos_s)
    pos_s.ah = pos_s.index * 32 or -1
    pos_s.pos_start = pos_s.index * 32 or -1
    pos_s.pos_offset = pos_s.index * 32 or -1
end

function sol:set_start_size(start_size_s)
    
end

return sol