-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

APP_NAME = 'thermal_mgmt'
local skynet = require 'skynet'
require 'skynet.manager'
local logging = require 'mc.logging'
local thermal_mgmt_app = require 'thermal_mgmt_app'

local CMD = {}

function CMD.exit()
    skynet.timeout(0, function()
        logging:info('- thermal_mgmt service exit')
        skynet.exit()
    end)
end

skynet.start(function()
    skynet.uniqueservice('sd_bus')
    skynet.register('thermal_mgmt')
    thermal_mgmt_app.new()
    skynet.dispatch('lua', function(_, _, cmd, ...)
        local f = assert(CMD[cmd])
        skynet.ret(skynet.pack(f(...)))
    end)
end)
