-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local ipmi = require 'ipmi'
local comp_code = ipmi.types.Cc
local class = require 'mc.class'
local singleton = require 'mc.singleton'
local msg = require 'thermal_mgmt.ipmi.ipmi_message'
local valve_service = require 'valve_service'
local log = require 'mc.logging'

local valve_ipmi = class()

function valve_ipmi:ctor()
end

function valve_ipmi:get_valve_opening_degree(req, ctx, ...)
    local device_id = req['Index']

    local opening_degree, cc = valve_service.get_instance():get_valve_opening_degree(device_id)

    return msg.GetValveOpeningDegreeRsp.new(cc, req.ManufactureId, opening_degree)
end

function valve_ipmi:get_valve_standard_opening_degree(req, ctx, ...)
    local device_id = req['Index']

    local opening_degree, cc = valve_service.get_instance():get_valve_standard_opening_degree(device_id)

    return msg.GetValveStandardOpeningDegreeRsp.new(cc, req.ManufactureId, opening_degree)
end

function valve_ipmi:set_valve_opening_degree(req, ctx, ...)
    local device_id = req['Index']
    local degree = req['Data']

    local cc = valve_service.get_instance():set_valve_opening_degree(ctx, device_id, degree)

    return msg.SetValveOpeningDegreeRsp.new(cc, req.ManufactureId)
end

return singleton(valve_ipmi)