-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local c_object = require 'mc.orm.object'
local log = require 'mc.logging'
local fan_group_object = c_object('FanGroup')

function fan_group_object:ctor()
    self.max_speed_percent = 0
end

function fan_group_object:init()
    self:connect_signal(self.on_add_object, function()
    end)
    self:connect_signal(self.on_add_object_complete, function()
        log:notice('on_add_object_complete group id: %d, FanSlots: %s, ResetSpeedPercent: %s',
            self.Id, table.concat(self.FanSlots, ' '), self.ResetSpeedPercent)
    end)
    fan_group_object.super.init(self)
end

return fan_group_object