-- Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local libpid = require 'libpid'
local plugin_method_init = {}

-- 对外插件方法的注册
function plugin_method_init.privite_method_register(base_service)
    -- 指定未实现插件时的默认方法
    base_service:ImplCustomTarTempCtrInit(function(...)
        return libpid.TarTempCtrInit(...)
    end)
    base_service:ImplCustomPidUpdateSensorValue(function(...)
        return libpid.PidUpdateSensorValue()
    end)
    base_service:ImplCustomPidCountValue(function(...)
        return libpid.PidCountValue()
    end)
    base_service:ImplCustomSetTargetTempConfig(function(length, info)
        return libpid.WriteInfo(length, info)
    end)
    base_service:ImplCustomSetFanConfig(function(length, info)
        return libpid.WriteInfo(length, info)
    end)
    base_service:ImplCustomSetRealTimeTemp(function(length, info)
        return libpid.WriteInfo(length, info)
    end)
    base_service:ImplCustomSetEnvTempConfig(function(length, info)
        return libpid.WriteInfo(length, info)
    end)
    base_service:ImplCustomSetFanAlarmSpeed(function(length, info)
        return libpid.WriteInfo(length, info)
    end)
    base_service:ImplCustomReadInfo(function(...)
        return libpid.ReadInfo(...)
    end)
end

return plugin_method_init