-- Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local PCIE_CARD = {
    NAME = "Name" -- 产品名称
}

local FRUCTL = {
    POWER_STATE = "PowerState" -- 上下电状态
}

local HDD_BACK_PLANE = {
    NAME = "Name" -- 单板名
}

local props = {
    FAN_LEVEL = 'FanLevel',
    CTL_MODE = 'CtrlMode',
    CTL_MODE_RESET_PERSIST = 'CtrlModeResetPersist',
    CTL_MODE_POWEROFF_PERSIST = 'CtrlModePoweroffPersist',
    FAN_CTL_ENABLE = 'FanCtrlEnable',
    CTRL_MODE_PERSIST_TYPE = 'CtrlModePersistType',
    FAN_MANUAL_MODE_CTL_NODE = 'FanManualModeCtrlNode',
    COOLING_WAY = 'CoolingWay',
    LEVEL_RANGE = 'LevelPercentRange',
    TIME_OUT = 'TimeOut',
    FAN_ID = 'FanId',
    FAN_SLOT = 'Slot',
    FAN_FRONT_PRESENCE = 'FrontPresence',
    FAN_REAR_PRESENCE = 'RearPresence',
    SMART_COOLING_STATE = 'SmartCoolingState',
    SMART_COOLING_MODE = 'SmartCoolingMode',
    ORIGINAL_SMART_COOLING_MODE = 'OriginalSmartCoolingMode',
    COOLING_MEDIUM = 'Medium',
    CONF_MANUAL_LEVEL = 'ManualLevel',
    INIT_LEVEL_IN_STARTUP = 'InitLevelInStartup',
    CUSTOM_SETTING_MASK = 'CustomSettingMask',
    REQUIREMENT_ID = 'RequirementId', -- 支持8位和16位,前8位为基础Id,一种调速点占据一个唯一的Id,多槽位器件必须配置后8位的槽位号
    REQ_BASE_ID = 'BaseId', -- 调速点基础Id,一种调速点占据一个唯一的Id
    REQ_SLOT = 'Slot', -- 槽位号,硬盘和卡等器件槽位需要配置于RequirementId的后8位,代码中赋值给Slot
    ACTIVE_IN_STANDBY = 'ActiveInStandby',
    TEMPERATURE_TYPE = 'TemperatureType',
    CUSTOM_CPU_CORE_TEMP_MIN = 'CustomCpuCoremTobjRangeMin',
    CUSTOM_CPU_CORE_TEMP_MAX = 'CustomCpuCoremTobjRangeMax',
    TARGET_TEMP_CELSIUS = 'TargetTemperatureCelsius',
    TARGET_TEMP_RANGE_CELSIUS = 'TargetTemperatureRangeCelsius',
    CUSTOM_TARGET_TEMP_CELSIUS = 'CustomTargetTemperatureCelsius',
    MONITORING_STATUS = 'MonitoringStatus',
    BCK_MONITORING_STATUS = 'MonitoringBackupStatus',
    POLICY_CUSTOM_SUPPORTED = 'CustomSupported',
    POLICY_IDX = 'PolicyIdx',
    POLICY_TYPE = 'PolicyType',
    POLICY_TEMP_RANGE_LOW = 'TemperatureRangeLow',
    POLICY_TEMP_RANGE_HIGHT = 'TemperatureRangeHigh',
    POLICY_SPEED_RANGE_LOW = 'SpeedRangeLow',
    POLICY_SPEED_RANGE_HIGH = 'SpeedRangeHigh',
    POLICY_SPEED_RANGE = 'FanSpeedRangePercents',
    POLICY_TEMP_ARRAY = 'TemperatureArray',
    POLICY_SPEED_ARRAY = 'FanSpeedArray',
    COOLING_FAN = 'CoolingFan',
    FRONT_STATUS = 'FrontStatus',
    REAR_STATUS = 'RearStatus',
    ABNORMAL_FAN = 'AbnormalFan',
    FAN_GROUP = 'FanGroup',
    PUMP_AREA_NAME = 'CoolingArea_Pump',    -- pump对应的coolingArea的对象名称
    LIQUID_DEVICE_GROUP ='LiquidCoolingDeviceGroup', --液冷器件调速组
    VALID_STATUS = 'Status',
    SPEED_PERCENTAGE = 'SpeedPercentage',
    COOLING_AREA = 'CoolingArea',
    REQ_IDX = 'RequirementIdx',
    POLICY_IDX_GROUP = 'PolicyIdxGroup',
    FAILED_VALUE = 'FailedValue',
    HARDWARE_PWM = 'HardwarePWM', -- 硬件PWM
    MAX_SUPPORTED_PWM = 'MaxSupportedPWM', --支持最大PWM
    FAN_MODEL = 'Model', -- 风扇类型
    SYSTEM_POWER = 'SystemPower', --系统功耗,
    FAN_TOTAL_POWER_WATTS = 'FanTotalPowerWatts', --风扇总功耗
    CONSUMED_POWER_WATT = 'ConsumedPowerWatt', --CPU总功耗
    IS_VALID = 'IsValid', --是否生效
    MONITORING_VALUE = 'MonitoringValue', --监控状态
    COOLING_POLICY_MEDIUM = 'CoolingMedium', --调速策略所对应介质
    COOLING_AIR = 'Air',
    COOLING_LIQUID  = 'Liquid',
    MAX_ALLOWED_TEMPERATURE_CELSIUS = 'MaxAllowedTemperatureCelsius',
    SMART_COOLING_TARTGET_TEMPERATURE = 'SmartCoolingTargetTemperature',
    SMART_COOLING_TARTGET_TEMPERATURE_CELSIUS = 'SmartCoolingTargetTemperatureCelsius',
    HYSTERESIS = 'Hysteresis',
    PUMP_PRESENCE = 'Presence',
    PUMP_STATUS = 'Status',
    PUMP_ID = 'Id',
    COOLING_AREA_PRIORITY = 'Priority',
    ABNORMAL_FAN_PRIORITY = 'Priority',
    FAN_BOARD_NUM = 'FanBoardNum',
    MAX_PUMP_NUM = 'MaxPumpNum',
    OBJECT_NAME = 'ObjectName',
    LEAK_DETECT_SUPPORT = 'Enabled', -- 是否使能漏液动作
    LEAK_STATE = 'LeakState', -- 漏液状态,0:无漏液,1:轻微漏液,2:严重漏液
    LEAK_POWER_POLICY = 'LeakPowerPolicy', -- 漏液上下电策略,0:不操作,1:自动下电
    LEAK_VALVE_POLICY = 'LeakValvePolicy',-- 漏液关断阀策略,0:不操作,1:自动关断
    SENSOR_LOCATION_SUPPORTED = 'SensorLocationSupported', -- 是否支持温度海洋界面显示
    DEVICE_LOCATOR = 'DeviceLocator', -- 当前单颗CPU名称
    POWER_WATT = 'PowerWatt', --当前单颗CPU功耗
    TEMPERATURE_CELSIUS = 'TemperatureCelsius', --当前单颗CPU温度
    TOTAL_CORES = 'TotalCores', --当前单颗CPU核数
    NPU_NAME = 'Name', -- 当前单颗NPU名称
    NPU_POWER_WATT = 'Power', --当前单颗NPU功耗
    NPU_AI_CORE_TEMP = 'AiCoreTemp', --当前单颗NPU温度
    NPU_CORE_USAGE = 'AiCoreUsagePercent', --当前单颗NPU温度
    NPU_CORE_FREQUENCY = 'AiCoreCurrentSpeedMHz', --当前单颗NPU的频率
    MPC_DEVICE = 'Device', -- MPC控温器件
    MPC_AREAID = 'AreaId', -- MPC控温器件对应的CoolingAreaId，通过CoolingAreaId获取风扇ID
    FAN_IDX_GROUP = 'FanIdxGroup', -- CoolingArea对应的调速风扇ID
    MANUFACTURING_MODE = "Mode", --装备模式标识
    EXPECTED_SPEED_PERCENT = "ExpectedSpeedPercent",
    SPEED_PERCENT_RANGE = "SpeedPercentRange",
    MANUAL_SPEED_PERCENT = "ManualSpeedPercent",
    MANUAL_SPEED_PERCENT_RESET_PERSIST = "ManualSpeedPercentResetPersist",
    MANUAL_SPEED_PERCENT_POWEROFF_PERSIST = "ManualSpeedPercentPoweroffPersist",
    INITIAL_SPEED_PERCENT = "InitialSpeedPercent",
    ACTIVE_ALGORITHM = "ActiveAlgorithm",

    -- 目标调速CSR原始值 
    ORIGIN_TARGET_TEMP_CELSIUS = 'OriginTargetTemperatureCelsius',
    ORIGIN_FAILED_VALUE = 'OriginFailedValue',
    ORIGIN_MAX_ALLOWED_TEMPERATURE_CELSIUS = 'OriginMaxAllowedTemperatureCelsius',
    ORIGIN_SMART_COOLING_TARTGET_TEMPERATURE = 'OriginSmartCoolingTargetTemperature',

    -- 曲线调速CSR原始值
    ORIGIN_POLICY_TEMP_RANGE_LOW = 'OriginTemperatureRangeLow',
    ORIGIN_POLICY_TEMP_RANGE_HIGHT = 'OriginTemperatureRangeHigh',
    ORIGIN_POLICY_SPEED_RANGE_LOW = 'OriginSpeedRangeLow',
    ORIGIN_POLICY_SPEED_RANGE_HIGH = 'OriginSpeedRangeHigh',

    -- 私有属性
    MIXED_MODE_SUPPORTED = 'MixedModeSupported',

    PCIE_CARD = PCIE_CARD,
    FRUCTL = FRUCTL,
    HDD_BACK_PLANE = HDD_BACK_PLANE
}

return props