-- Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local mode_enum = {
    Auto = 'Auto',
    Manual = 'Manual',
    Mixed = 'Mixed'
}

local persist_type = {
    Memory = 0,
    ResetPer = 1,
    PoweroffPer = 2
}

local cooling_mediums = {
    AIR_COOLING = 'Air',
    LIQUID_COOLING = 'Liquid',
}
local smart_cooling_modes = {
    LOW_POWER_MODE = 'LowPowerConsumption',
    HIGH_POWER_MODE = 'HighPowerConsumption',
    MIDDLE_POWER_MODE = 'MediumPowerConsumption',
    COOLING_ENERGY_SAVING_MODE = 'EnergySaving',
    COOLING_LOW_NOISE_MODE = 'LowNoise',
    COOLING_HIGH_PERFORMANCE_MODE = 'HighPerformance',
    COOLING_CUSTOM_MODE = 'Custom',
    COOLING_LIQUID_MODE = 'LiquidCooling',
}
-- 传入标志位与该字段做与运算来判断更新SmartCoolingMode/OriginalSmartCoolingMode,还是两者皆更新
local smart_cooling_changed = {
    BASIC = 1,
    ORIGINAL = 2,
    BOTH = 3
}
local custom_tobj_bit_offset = {
    CUSTOMMODE_INLETTEMP = 0,
    CUSTOMMODE_CUPTEMP = 1,
    CUSTOMMODE_OUTTEMP = 2,
    CUSTOMMODE_DISK_ENV = 3,
    CUSTOMMODE_DISK_TOBJ = 4,
    CUSTOMMODE_MEMORY_TOBJ = 5,
    CUSTOMMODE_PCH_TOBJ = 6,
    CUSTOMMODE_VRD_TOBJ = 7,
    CUSTOMMODE_VDDQ_TOBJ = 8,
    CUSTOMMODE_NPU_HBM_TOBJ = 9,
    CUSTOMMODE_NPU_AICORE_TOBJ = 10,
    CUSTOMMODE_SOCBRD_INLET_TOBJ = 12,
    CUSTOMMODE_SOCBRD_OUTLET_TOBJ = 13,
}
local smart_cooling_state = {
    ENABLED = 'Enabled',
    DISABLED = 'Disabled'
}
local cooling_way = {
    PROACTIVE = 'Proactive', -- 主动散热
    PASSIVE = 'Passive'      -- 被动散热  
}
local alarm = {
    NORMAL_SPEED_INDEX = 1,   -- 1-健康
    MINOR_SPEED_INDEX = 2,    -- 2-一般告警
    MAJOR_SPEED_INDEX = 3,    -- 3-严重告警
    CRITICAL_SPEED_INDEX = 4, -- 4-紧急告警
}

local log_level = {
    ERROR = 1,
    INFO = 2,
    DEBUG = 3
}

local exp_type = {
    ABNORMAL_REQ = 'AbnormalRequirement',
    ALARM_REQ = 'AlarmRequirement',
    ABNORMAL_FAN = 'AbnormalFan',
    ABNORMAL_PUMP = 'AbnormalPump'
}

local fan_abnormal_level = {
    NORMAL = 0,
    NOT_IN_PRESENT_FRONT = 1,
    NOT_IN_PRESENT_REAR = 2,
    ABNORMAL_ROTATION_FRONT = 3,
    ABNORMAL_ROTATION_REAR = 4
}

local fan_abnormal_status_mapping = {
    [fan_abnormal_level.NORMAL] = 'Normal',
    [fan_abnormal_level.NOT_IN_PRESENT_FRONT] = 'NotInPosition',
    [fan_abnormal_level.NOT_IN_PRESENT_REAR] = 'NotInPosition',
    [fan_abnormal_level.ABNORMAL_ROTATION_FRONT] = 'AbnormalRotation',
    [fan_abnormal_level.ABNORMAL_ROTATION_REAR] = 'AbnormalRotation'
}

local fan_abnormal_status_mapping_for_ipmi = {
    [fan_abnormal_level.NORMAL] = 'Normal',
    [fan_abnormal_level.NOT_IN_PRESENT_FRONT] = 'Presence',
    [fan_abnormal_level.NOT_IN_PRESENT_REAR] = 'R Presence',
    [fan_abnormal_level.ABNORMAL_ROTATION_FRONT] = 'Status',
    [fan_abnormal_level.ABNORMAL_ROTATION_REAR] = 'R Status'
}

-- 最大风扇转速调速类型
local max_fan_pwm_type = {
    FAN = 'fan',
    REQUIREMENT = 'requirement',
    PID = 'pid'
}

local power_status = {
    ON = 'ON',
    ONING = 'ONING',
    OFF = 'OFF',
    OFFING = 'OFFING'
}

local bmc_reset_type = {
    HARD_RESET = 0,
    SOFT_RESET_UID = 1,
    SOFT_RESET_NORMAL = 2
}

local privilege_bitmap = {
    ReadOnly = 2 ^ 0,
    DiagnoseMgmt = 2 ^ 1,
    SecurityMgmt = 2 ^ 2,
    BasicSetting = 2 ^ 3,
    UserMgmt = 2 ^ 4,
    PowerMgmt = 2 ^ 5,
    VMMMgmt = 2 ^ 6,
    KVMMgmt = 2 ^ 7,
    ConfigureSelf = 2 ^ 8
}

local data_type = {
    INTEGER = 'integer',
    TABLE = 'table',
    STRING = 'string',
    NIL = 'nil'
}

local requirementId_cpu_mapping = {
    [20] = 'CPU1',
    [22] = 'CPU2'
}

local mpc_working_condition_db_name = {
    ['CPU1'] = 'MPCCPU1WorkingCondition',
    ['CPU2'] = 'MPCCPU2WorkingCondition'
}

local mpc_model_status = {
    IDLE = 'Idle',
    TRAINING = 'Training',
    ACTIVE = 'Active',
    INACTIVE = 'Inactive',
    UNAVAILABLE = 'Unavailable'
}

local manufacture_mode = {
    FT = 0,
    ST = 1
}

local policy_type = {
    Inlet = 1,
    Disk = 2
}

local DATA_KEEPING_CONFIG = {
    FOREACH_FUNC = 'ForeachObjects', -- 对象遍历函数
    PROPERTIES = 'Properties' -- 监听属性
}

local DATA_KEEPING_LOG = {
    LOG = 'Log', -- 记录日志
    NO_LOG = 'NoLog' -- 不记录日志
}

local AUTO_ACTIVE_ALGORITHM = {
    DEFAULT = "N/A",
    PID = "PID",
    MPC = "MPC"
}

local cooling_enums = {
    modes = mode_enum,
    persist_type = persist_type,
    cooling_mediums = cooling_mediums,
    smart_cooling_mode = smart_cooling_modes,
    smart_cooling_changed = smart_cooling_changed,
    tobj_offset = custom_tobj_bit_offset,
    smart_cooling_state = smart_cooling_state,
    alarm = alarm,
    cooling_way = cooling_way,
    log_level = log_level,
    exp_type = exp_type,
    power_status = power_status,
    privilege_bitmap = privilege_bitmap,
    data_type = data_type,
    fan_abnormal_level = fan_abnormal_level,
    fan_abnormal_status_mapping = fan_abnormal_status_mapping,
    max_fan_pwm_type = max_fan_pwm_type,
    fan_abnormal_status_mapping_for_ipmi = fan_abnormal_status_mapping_for_ipmi,
    bmc_reset_type = bmc_reset_type,
    requirementId_cpu_mapping = requirementId_cpu_mapping,
    mpc_working_condition_db_name = mpc_working_condition_db_name,
    mpc_model_status = mpc_model_status,
    manufacture_mode = manufacture_mode,
    policy_type = policy_type,
    data_keeping_config = DATA_KEEPING_CONFIG,
    data_keeping_log = DATA_KEEPING_LOG,
    auto_active_algorithm = AUTO_ACTIVE_ALGORITHM
}

return cooling_enums