-- Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local log = require 'mc.logging'
local client = require 'thermal_mgmt.client'
local enums = require 'basic_cooling.define.cooling_enums'
local props = require 'basic_cooling.define.cooling_properties'
local base = require 'basic_cooling.data_keeping.base'
local singleton = require 'mc.singleton'

local fan_board_data_keeping = class(base)

function fan_board_data_keeping:ctor(bus)
    self.obj_name = "FanBoard"
    -- 监听的资源树路径
    self.paths_table = {
        "/bmc/kepler/Systems/${SystemId}/Boards/FanBoard/${Id}"
    }
    -- 监听的接口
    self.interfaces_table = {
        ["bmc.kepler.Systems.Board"] = {
            [enums.data_keeping_config.FOREACH_FUNC] = client.ForeachBoardObjects,
            [enums.data_keeping_config.PROPERTIES] = {
                ['Name'] = enums.data_keeping_log.LOG
            }
        }
    }
end

function fan_board_data_keeping:init()
    self.super.init(self)
end

function fan_board_data_keeping:get_total_power_watts()
    if not self.objs then
        return nil
    end
    local total_power_watts = 0
    for _, interface_objs in pairs(self.objs) do
        for _, interface_obj in pairs(interface_objs) do
            total_power_watts = total_power_watts + interface_obj.obj.PowerWatts
        end
    end
    return total_power_watts
end

return singleton(fan_board_data_keeping)