-- Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local client = require 'thermal_mgmt.client'
local singleton = require 'mc.singleton'
local log = require 'mc.logging'

local bmc_soc_data = class()

function bmc_soc_data:ctor()
    self.bmc_reset_type = nil -- 0 AC复位 2 软复位
    self.intf = 'bmc.kepler.Managers.SOC'
end

function bmc_soc_data:init()
end

-- 防止模块重启监听电源状态获取不到值
function bmc_soc_data:get_bmc_reset_type()
    if self.bmc_reset_type then
        return self.bmc_reset_type
    end
    client:ForeachSOCObjects(function (obj)
        if obj.ResetType then
            self.bmc_reset_type = obj.ResetType
            log:notice('Current bmc reset type is %s', self.bmc_reset_type)
            return self.bmc_reset_type
        end
    end)
    -- 获取bmc_soc对象失败
    log:debug('Get bmc_soc obj(interface:%s) failed', self.intf)
    return nil
end

return singleton(bmc_soc_data)