-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local log = require 'mc.logging'
local singleton = require 'mc.singleton'
local c_fan_group_object = require 'fan_group_object'
local c_pump_group_object = require 'pump_group_object'
local c_fan_object = require 'fan_object'

local cooling_group = class()

function cooling_group:get_fan_group_control_table()
    local fan_table = {}
    c_fan_group_object.collection:fold(function (_, fan_group_obj)
        for _, slot in pairs(fan_group_obj.FanSlots) do
            fan_table[slot] = fan_group_obj.ExpectedSpeedPercent
        end
    end)
    return fan_table
end

function cooling_group:get_pump_group_control_table()
    local pump_table = {}
    c_pump_group_object.collection:fold(function (_, pump_group_obj)
        for _, slot in pairs(pump_group_obj.PumpSlots) do
            pump_table[slot] = pump_group_obj.ExpectedSpeedPercent
        end
    end)
    return pump_table
end

function cooling_group:get_fan_obj(fan_id)
    local obj = nil
    c_fan_object.collection:fold(function(_, fan_obj)
        if fan_obj.FanId == fan_id then
            obj = fan_obj
            return
        end
    end)
    return obj
end

function cooling_group:get_fans_info_with_fan_id()
    local fans_info = {}
    local fan_id
    c_fan_object.collection:fold(function(_, fan_obj)
        fan_id = fan_obj.FanId
        fans_info[fan_id] = fan_obj
    end)
    return fans_info
end

function cooling_group:get_system_fan_type()
    local model = nil
    c_fan_object.collection:fold(function(_, fan_obj)
        if type(fan_obj.Model) == 'string' and string.len(fan_obj.Model) ~= 0 then
            model = fan_obj.Model
            return
        end
    end)
    return model
end

return singleton(cooling_group)