-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local ipmi = require 'ipmi'
local mdb = require 'mc.mdb'
local class = require 'mc.class'
local context = require 'mc.context'
local open_db = require 'thermal_mgmt.db'
local app_base = require 'mc.service_app_base'
local object_manage = require 'mc.mdb.object_manage'
local persist_client = require 'persistence.persist_client_lib'
local orm_classes = require 'thermal_mgmt.orm_classes'
local ok, datas = pcall(require, 'thermal_mgmt.datas')
if not ok then
    datas = nil -- 如果没有datas配置，证明当前组件不需要datas，仅打开数据库
end

local FanTypes = require 'thermal_mgmt.json_types.Fan'
local MetricTypes = require 'thermal_mgmt.json_types.Metric'
local PropertiesTypes = require 'thermal_mgmt.json_types.Properties'
local FanTypeTypes = require 'thermal_mgmt.json_types.FanType'
local FansTypes = require 'thermal_mgmt.json_types.Fans'
local PumpsTypes = require 'thermal_mgmt.json_types.Pumps'
local PumpTypes = require 'thermal_mgmt.json_types.Pump'
local ValvesTypes = require 'thermal_mgmt.json_types.Valves'
local ValveTypes = require 'thermal_mgmt.json_types.Valve'
local FanGroupTypes = require 'thermal_mgmt.json_types.FanGroup'
local PumpGroupTypes = require 'thermal_mgmt.json_types.PumpGroup'
local CoolingConfigTypes = require 'thermal_mgmt.json_types.CoolingConfig'
local DiskCoolingConfigTypes = require 'thermal_mgmt.json_types.DiskCoolingConfig'
local AirCoolingConfigTypes = require 'thermal_mgmt.json_types.AirCoolingConfig'
local FanSnapshotTypes = require 'thermal_mgmt.json_types.FanSnapshot'
local LiquidCoolingConfigTypes = require 'thermal_mgmt.json_types.LiquidCoolingConfig'
local CoolingFanTypes = require 'thermal_mgmt.json_types.CoolingFan'
local CoolingPumpTypes = require 'thermal_mgmt.json_types.CoolingPump'
local CoolingRequirementTypes = require 'thermal_mgmt.json_types.CoolingRequirement'
local CoolingPolicyTypes = require 'thermal_mgmt.json_types.CoolingPolicy'
local CoolingAreaTypes = require 'thermal_mgmt.json_types.CoolingArea'
local CoolingPoliciesTypes = require 'thermal_mgmt.json_types.CoolingPolicies'
local MetricsTypes = require 'thermal_mgmt.json_types.Metrics'
local ThermalMgmtTypes = require 'thermal_mgmt.json_types.ThermalMgmt'
local ThermalControlStrategyTypes = require 'thermal_mgmt.json_types.ThermalControlStrategy'

local Fan = mdb.register_object('/bmc/kepler/Systems/:SystemId/Thermal/Fans/:Id', {
    {name = 'bmc.kepler.Systems.Fan', interface = FanTypes.interface},
    {name = 'bmc.kepler.Metric', interface = MetricTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function Fan:ctor(SystemId, Id)
    self.path = '/bmc/kepler/Systems/' .. SystemId .. '/Thermal/Fans/' .. Id
end

local FanType = mdb.register_object('/bmc/kepler/Systems/:SystemId/Thermal/FanTypes/:Id', {
    {name = 'bmc.kepler.Systems.FanType', interface = FanTypeTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function FanType:ctor(SystemId, Id)
    self.path = '/bmc/kepler/Systems/' .. SystemId .. '/Thermal/FanTypes/' .. Id
end

local SystemsFans = mdb.register_object('/bmc/kepler/Systems/:SystemId/Thermal/Fans', {
    {name = 'bmc.kepler.Systems.Fans', interface = FansTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function SystemsFans:ctor(SystemId)
    self.path = '/bmc/kepler/Systems/' .. SystemId .. '/Thermal/Fans'
end

local Pumps = mdb.register_object('/bmc/kepler/Systems/:SystemId/Thermal/Pumps', {
    {name = 'bmc.kepler.Systems.Pumps', interface = PumpsTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function Pumps:ctor(SystemId)
    self.path = '/bmc/kepler/Systems/' .. SystemId .. '/Thermal/Pumps'
end

local Pump = mdb.register_object('/bmc/kepler/Systems/:SystemId/Thermal/Pumps/:Id', {
    {name = 'bmc.kepler.Systems.Pump', interface = PumpTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function Pump:ctor(SystemId, Id)
    self.path = '/bmc/kepler/Systems/' .. SystemId .. '/Thermal/Pumps/' .. Id
end

local Valves = mdb.register_object('/bmc/kepler/Chassis/:ChassisId/Thermal/Valves', {
    {name = 'bmc.kepler.Chassis.Valves', interface = ValvesTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function Valves:ctor(ChassisId)
    self.path = '/bmc/kepler/Chassis/' .. ChassisId .. '/Thermal/Valves'
end

local Valve = mdb.register_object('/bmc/kepler/Chassis/:ChassisId/Thermal/Valves/:Id', {
    {name = 'bmc.kepler.Chassis.Valve', interface = ValveTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function Valve:ctor(ChassisId, Id)
    self.path = '/bmc/kepler/Chassis/' .. ChassisId .. '/Thermal/Valves/' .. Id
end

local FanGroup = mdb.register_object('/bmc/kepler/Chassis/:ChassisId/ThermalSubsystem/FanGroups/:Id', {
    {name = 'bmc.kepler.Chassis.FanGroup', interface = FanGroupTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function FanGroup:ctor(ChassisId, Id)
    self.path = '/bmc/kepler/Chassis/' .. ChassisId .. '/ThermalSubsystem/FanGroups/' .. Id
end

local PumpGroup = mdb.register_object('/bmc/kepler/Chassis/:ChassisId/ThermalSubsystem/PumpGroups/:Id', {
    {name = 'bmc.kepler.Chassis.PumpGroup', interface = PumpGroupTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function PumpGroup:ctor(ChassisId, Id)
    self.path = '/bmc/kepler/Chassis/' .. ChassisId .. '/ThermalSubsystem/PumpGroups/' .. Id
end

local CoolingConfig = mdb.register_object('/bmc/kepler/Systems/:SystemId/CoolingConfig', {
    {name = 'bmc.kepler.Systems.CoolingConfig', interface = CoolingConfigTypes.interface},
    {name = 'bmc.kepler.Systems.DiskCoolingConfig', interface = DiskCoolingConfigTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function CoolingConfig:ctor(SystemId)
    self.path = '/bmc/kepler/Systems/' .. SystemId .. '/CoolingConfig'
end

local AirCoolingConfig = mdb.register_object('/bmc/kepler/Systems/:SystemId/AirCoolingConfig', {
    {name = 'bmc.kepler.Systems.AirCoolingConfig', interface = AirCoolingConfigTypes.interface},
    {name = 'bmc.kepler.Systems.FanSnapshot', interface = FanSnapshotTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function AirCoolingConfig:ctor(SystemId)
    self.path = '/bmc/kepler/Systems/' .. SystemId .. '/AirCoolingConfig'
end

local LiquidCoolingConfig = mdb.register_object('/bmc/kepler/Systems/:SystemId/LiquidCoolingConfig', {
    {name = 'bmc.kepler.Systems.LiquidCoolingConfig', interface = LiquidCoolingConfigTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function LiquidCoolingConfig:ctor(SystemId)
    self.path = '/bmc/kepler/Systems/' .. SystemId .. '/LiquidCoolingConfig'
end

local CoolingFan = mdb.register_object('/bmc/kepler/Systems/:SystemId/CoolingFan/:Id', {
    {name = 'bmc.kepler.Systems.CoolingFan', interface = CoolingFanTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function CoolingFan:ctor(SystemId, Id)
    self.path = '/bmc/kepler/Systems/' .. SystemId .. '/CoolingFan/' .. Id
end

local CoolingPump = mdb.register_object('/bmc/kepler/Systems/:SystemId/CoolingPumps/:Id', {
    {name = 'bmc.kepler.Systems.CoolingPump', interface = CoolingPumpTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function CoolingPump:ctor(SystemId, Id)
    self.path = '/bmc/kepler/Systems/' .. SystemId .. '/CoolingPumps/' .. Id
end

local CoolingRequirement = mdb.register_object('/bmc/kepler/Systems/:SystemId/CoolingRequirement/:Id', {
    {name = 'bmc.kepler.Systems.CoolingRequirement', interface = CoolingRequirementTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function CoolingRequirement:ctor(SystemId, Id)
    self.path = '/bmc/kepler/Systems/' .. SystemId .. '/CoolingRequirement/' .. Id
end

local CoolingPolicy = mdb.register_object('/bmc/kepler/Systems/:SystemId/CoolingPolicy/:Id', {
    {name = 'bmc.kepler.Systems.CoolingPolicy', interface = CoolingPolicyTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function CoolingPolicy:ctor(SystemId, Id)
    self.path = '/bmc/kepler/Systems/' .. SystemId .. '/CoolingPolicy/' .. Id
end

local CoolingArea = mdb.register_object('/bmc/kepler/Systems/:SystemId/CoolingArea/:Id', {
    {name = 'bmc.kepler.Systems.CoolingArea', interface = CoolingAreaTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function CoolingArea:ctor(SystemId, Id)
    self.path = '/bmc/kepler/Systems/' .. SystemId .. '/CoolingArea/' .. Id
end

local CoolingPolicies = mdb.register_object('/bmc/kepler/Chassis/:ChassisId/ThermalSubsystem/CoolingPolicies', {
    {name = 'bmc.kepler.Chassis.CoolingPolicies', interface = CoolingPoliciesTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function CoolingPolicies:ctor(ChassisId)
    self.path = '/bmc/kepler/Chassis/' .. ChassisId .. '/ThermalSubsystem/CoolingPolicies'
end

local ThermalSubsystem = mdb.register_object('/bmc/kepler/Chassis/:ChassisId/ThermalSubsystem', {
    {name = 'bmc.kepler.Chassis.ThermalSubsystem.Metrics', interface = MetricsTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function ThermalSubsystem:ctor(ChassisId)
    self.path = '/bmc/kepler/Chassis/' .. ChassisId .. '/ThermalSubsystem'
end

local ThermalMgmt = mdb.register_object('/bmc/kepler/ThermalMgmt', {
    {name = 'bmc.kepler.ThermalMgmt', interface = ThermalMgmtTypes.interface},
    {name = 'bmc.kepler.Release.ThermalControlStrategy', interface = ThermalControlStrategyTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function ThermalMgmt:ctor()
    self.path = '/bmc/kepler/ThermalMgmt'
end

local model = require 'class.model'

local thermal_mgmt_service = class(app_base.Service)

thermal_mgmt_service.package = 'thermal_mgmt'

function thermal_mgmt_service:CreateFan(SystemId, Id, prop_setting_cb)
    local path = '/bmc/kepler/Systems/' .. SystemId .. '/Thermal/Fans/' .. Id
    return object_manage.create_object('Fan', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreateFanType(SystemId, Id, prop_setting_cb)
    local path = '/bmc/kepler/Systems/' .. SystemId .. '/Thermal/FanTypes/' .. Id
    return object_manage.create_object('FanType', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreateSystemsFans(SystemId, prop_setting_cb)
    local path = '/bmc/kepler/Systems/' .. SystemId .. '/Thermal/Fans'
    return object_manage.create_object('SystemsFans', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreatePumps(SystemId, prop_setting_cb)
    local path = '/bmc/kepler/Systems/' .. SystemId .. '/Thermal/Pumps'
    return object_manage.create_object('Pumps', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreatePump(SystemId, Id, prop_setting_cb)
    local path = '/bmc/kepler/Systems/' .. SystemId .. '/Thermal/Pumps/' .. Id
    return object_manage.create_object('Pump', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreateValves(ChassisId, prop_setting_cb)
    local path = '/bmc/kepler/Chassis/' .. ChassisId .. '/Thermal/Valves'
    return object_manage.create_object('Valves', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreateValve(ChassisId, Id, prop_setting_cb)
    local path = '/bmc/kepler/Chassis/' .. ChassisId .. '/Thermal/Valves/' .. Id
    return object_manage.create_object('Valve', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreateFanGroup(ChassisId, Id, prop_setting_cb)
    local path = '/bmc/kepler/Chassis/' .. ChassisId .. '/ThermalSubsystem/FanGroups/' .. Id
    return object_manage.create_object('FanGroup', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreatePumpGroup(ChassisId, Id, prop_setting_cb)
    local path = '/bmc/kepler/Chassis/' .. ChassisId .. '/ThermalSubsystem/PumpGroups/' .. Id
    return object_manage.create_object('PumpGroup', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreateCoolingConfig(SystemId, prop_setting_cb)
    local path = '/bmc/kepler/Systems/' .. SystemId .. '/CoolingConfig'
    return object_manage.create_object('CoolingConfig', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreateAirCoolingConfig(SystemId, prop_setting_cb)
    local path = '/bmc/kepler/Systems/' .. SystemId .. '/AirCoolingConfig'
    return object_manage.create_object('AirCoolingConfig', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreateLiquidCoolingConfig(SystemId, prop_setting_cb)
    local path = '/bmc/kepler/Systems/' .. SystemId .. '/LiquidCoolingConfig'
    return object_manage.create_object('LiquidCoolingConfig', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreateCoolingFan(SystemId, Id, prop_setting_cb)
    local path = '/bmc/kepler/Systems/' .. SystemId .. '/CoolingFan/' .. Id
    return object_manage.create_object('CoolingFan', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreateCoolingPump(SystemId, Id, prop_setting_cb)
    local path = '/bmc/kepler/Systems/' .. SystemId .. '/CoolingPumps/' .. Id
    return object_manage.create_object('CoolingPump', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreateCoolingRequirement(SystemId, Id, prop_setting_cb)
    local path = '/bmc/kepler/Systems/' .. SystemId .. '/CoolingRequirement/' .. Id
    return object_manage.create_object('CoolingRequirement', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreateCoolingPolicy(SystemId, Id, prop_setting_cb)
    local path = '/bmc/kepler/Systems/' .. SystemId .. '/CoolingPolicy/' .. Id
    return object_manage.create_object('CoolingPolicy', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreateCoolingArea(SystemId, Id, prop_setting_cb)
    local path = '/bmc/kepler/Systems/' .. SystemId .. '/CoolingArea/' .. Id
    return object_manage.create_object('CoolingArea', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreateCoolingPolicies(ChassisId, prop_setting_cb)
    local path = '/bmc/kepler/Chassis/' .. ChassisId .. '/ThermalSubsystem/CoolingPolicies'
    return object_manage.create_object('CoolingPolicies', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreateThermalSubsystem(ChassisId, prop_setting_cb)
    local path = '/bmc/kepler/Chassis/' .. ChassisId .. '/ThermalSubsystem'
    return object_manage.create_object('ThermalSubsystem', path, path, prop_setting_cb)
end

function thermal_mgmt_service:CreateThermalMgmt(prop_setting_cb)
    return object_manage.create_object('ThermalMgmt', 'ThermalMgmt_0', '/bmc/kepler/ThermalMgmt', prop_setting_cb)
end

function thermal_mgmt_service:ImplFanFanSetFanPWM(cb)
    model.ImplFanFanSetFanPWM(cb)
end

function thermal_mgmt_service:ImplFanMetricGetData(cb)
    model.ImplFanMetricGetData(cb)
end

function thermal_mgmt_service:ImplFanMetricGetItems(cb)
    model.ImplFanMetricGetItems(cb)
end

function thermal_mgmt_service:ImplFanMetricSynDataAcquisitionEnable(cb)
    model.ImplFanMetricSynDataAcquisitionEnable(cb)
end

function thermal_mgmt_service:ImplFanPropertiesGetOptions(cb)
    model.ImplFanPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplFanPropertiesGetPropertiesByOptions(cb)
    model.ImplFanPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplFanTypePropertiesGetOptions(cb)
    model.ImplFanTypePropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplFanTypePropertiesGetPropertiesByOptions(cb)
    model.ImplFanTypePropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplSystemsFansFansSetPWM(cb)
    model.ImplSystemsFansFansSetPWM(cb)
end

function thermal_mgmt_service:ImplSystemsFansPropertiesGetOptions(cb)
    model.ImplSystemsFansPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplSystemsFansPropertiesGetPropertiesByOptions(cb)
    model.ImplSystemsFansPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplPumpsPumpsSetPWM(cb)
    model.ImplPumpsPumpsSetPWM(cb)
end

function thermal_mgmt_service:ImplPumpsPropertiesGetOptions(cb)
    model.ImplPumpsPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplPumpsPropertiesGetPropertiesByOptions(cb)
    model.ImplPumpsPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplPumpPropertiesGetOptions(cb)
    model.ImplPumpPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplPumpPropertiesGetPropertiesByOptions(cb)
    model.ImplPumpPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplValvesValvesStartPatrol(cb)
    model.ImplValvesValvesStartPatrol(cb)
end

function thermal_mgmt_service:ImplValvesPropertiesGetOptions(cb)
    model.ImplValvesPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplValvesPropertiesGetPropertiesByOptions(cb)
    model.ImplValvesPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplValvePropertiesGetOptions(cb)
    model.ImplValvePropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplValvePropertiesGetPropertiesByOptions(cb)
    model.ImplValvePropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplFanGroupPropertiesGetOptions(cb)
    model.ImplFanGroupPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplFanGroupPropertiesGetPropertiesByOptions(cb)
    model.ImplFanGroupPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplPumpGroupPropertiesGetOptions(cb)
    model.ImplPumpGroupPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplPumpGroupPropertiesGetPropertiesByOptions(cb)
    model.ImplPumpGroupPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplCoolingConfigCoolingConfigSetCtrlMode(cb)
    model.ImplCoolingConfigCoolingConfigSetCtrlMode(cb)
end

function thermal_mgmt_service:ImplCoolingConfigCoolingConfigSetManualLevel(cb)
    model.ImplCoolingConfigCoolingConfigSetManualLevel(cb)
end

function thermal_mgmt_service:ImplCoolingConfigCoolingConfigSetMedium(cb)
    model.ImplCoolingConfigCoolingConfigSetMedium(cb)
end

function thermal_mgmt_service:ImplCoolingConfigCoolingConfigSetSmartCoolingMode(cb)
    model.ImplCoolingConfigCoolingConfigSetSmartCoolingMode(cb)
end

function thermal_mgmt_service:ImplCoolingConfigCoolingConfigGetAbnormalPolicyEffectiveStatus(cb)
    model.ImplCoolingConfigCoolingConfigGetAbnormalPolicyEffectiveStatus(cb)
end

function thermal_mgmt_service:ImplCoolingConfigCoolingConfigSetMinPWM(cb)
    model.ImplCoolingConfigCoolingConfigSetMinPWM(cb)
end

function thermal_mgmt_service:ImplCoolingConfigCoolingConfigGetComponentThermalZone(cb)
    model.ImplCoolingConfigCoolingConfigGetComponentThermalZone(cb)
end

function thermal_mgmt_service:ImplCoolingConfigCoolingConfigGetCustomTargetTemperatures(cb)
    model.ImplCoolingConfigCoolingConfigGetCustomTargetTemperatures(cb)
end

function thermal_mgmt_service:ImplCoolingConfigPropertiesGetOptions(cb)
    model.ImplCoolingConfigPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplCoolingConfigPropertiesGetPropertiesByOptions(cb)
    model.ImplCoolingConfigPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplAirCoolingConfigAirCoolingConfigSetCtrlMode(cb)
    model.ImplAirCoolingConfigAirCoolingConfigSetCtrlMode(cb)
end

function thermal_mgmt_service:ImplAirCoolingConfigAirCoolingConfigSetCtrlModePersist(cb)
    model.ImplAirCoolingConfigAirCoolingConfigSetCtrlModePersist(cb)
end

function thermal_mgmt_service:ImplAirCoolingConfigAirCoolingConfigSetManualSpeedPercent(cb)
    model.ImplAirCoolingConfigAirCoolingConfigSetManualSpeedPercent(cb)
end

function thermal_mgmt_service:ImplAirCoolingConfigFanSnapshotGetActivatedPolicyFactors(cb)
    model.ImplAirCoolingConfigFanSnapshotGetActivatedPolicyFactors(cb)
end

function thermal_mgmt_service:ImplAirCoolingConfigPropertiesGetOptions(cb)
    model.ImplAirCoolingConfigPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplAirCoolingConfigPropertiesGetPropertiesByOptions(cb)
    model.ImplAirCoolingConfigPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplLiquidCoolingConfigLiquidCoolingConfigSetManualLevel(cb)
    model.ImplLiquidCoolingConfigLiquidCoolingConfigSetManualLevel(cb)
end

function thermal_mgmt_service:ImplLiquidCoolingConfigLiquidCoolingConfigSetCtrlMode(cb)
    model.ImplLiquidCoolingConfigLiquidCoolingConfigSetCtrlMode(cb)
end

function thermal_mgmt_service:ImplLiquidCoolingConfigPropertiesGetOptions(cb)
    model.ImplLiquidCoolingConfigPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplLiquidCoolingConfigPropertiesGetPropertiesByOptions(cb)
    model.ImplLiquidCoolingConfigPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplCoolingFanPropertiesGetOptions(cb)
    model.ImplCoolingFanPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplCoolingFanPropertiesGetPropertiesByOptions(cb)
    model.ImplCoolingFanPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplCoolingPumpPropertiesGetOptions(cb)
    model.ImplCoolingPumpPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplCoolingPumpPropertiesGetPropertiesByOptions(cb)
    model.ImplCoolingPumpPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplCoolingRequirementCoolingRequirementSetTargetTemperature(cb)
    model.ImplCoolingRequirementCoolingRequirementSetTargetTemperature(cb)
end

function thermal_mgmt_service:ImplCoolingRequirementCoolingRequirementSetSmartCoolingTargetTemperature(cb)
    model.ImplCoolingRequirementCoolingRequirementSetSmartCoolingTargetTemperature(cb)
end

function thermal_mgmt_service:ImplCoolingRequirementCoolingRequirementSetBasicCoolingTargetTemperature(cb)
    model.ImplCoolingRequirementCoolingRequirementSetBasicCoolingTargetTemperature(cb)
end

function thermal_mgmt_service:ImplCoolingRequirementCoolingRequirementSetMaxAllowedTemperature(cb)
    model.ImplCoolingRequirementCoolingRequirementSetMaxAllowedTemperature(cb)
end

function thermal_mgmt_service:ImplCoolingRequirementCoolingRequirementSetFailedValue(cb)
    model.ImplCoolingRequirementCoolingRequirementSetFailedValue(cb)
end

function thermal_mgmt_service:ImplCoolingRequirementCoolingRequirementSetBackupTemperatureCelsius(cb)
    model.ImplCoolingRequirementCoolingRequirementSetBackupTemperatureCelsius(cb)
end

function thermal_mgmt_service:ImplCoolingRequirementCoolingRequirementSetBackupTemperatureStatus(cb)
    model.ImplCoolingRequirementCoolingRequirementSetBackupTemperatureStatus(cb)
end

function thermal_mgmt_service:ImplCoolingRequirementPropertiesGetOptions(cb)
    model.ImplCoolingRequirementPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplCoolingRequirementPropertiesGetPropertiesByOptions(cb)
    model.ImplCoolingRequirementPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplCoolingPolicyCoolingPolicySetCustomCoolingPolicy(cb)
    model.ImplCoolingPolicyCoolingPolicySetCustomCoolingPolicy(cb)
end

function thermal_mgmt_service:ImplCoolingPolicyCoolingPolicySetHysteresis(cb)
    model.ImplCoolingPolicyCoolingPolicySetHysteresis(cb)
end

function thermal_mgmt_service:ImplCoolingPolicyPropertiesGetOptions(cb)
    model.ImplCoolingPolicyPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplCoolingPolicyPropertiesGetPropertiesByOptions(cb)
    model.ImplCoolingPolicyPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplCoolingAreaPropertiesGetOptions(cb)
    model.ImplCoolingAreaPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplCoolingAreaPropertiesGetPropertiesByOptions(cb)
    model.ImplCoolingAreaPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplCoolingPoliciesCoolingPoliciesGetSpecificPWM(cb)
    model.ImplCoolingPoliciesCoolingPoliciesGetSpecificPWM(cb)
end

function thermal_mgmt_service:ImplCoolingPoliciesPropertiesGetOptions(cb)
    model.ImplCoolingPoliciesPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplCoolingPoliciesPropertiesGetPropertiesByOptions(cb)
    model.ImplCoolingPoliciesPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplThermalSubsystemMetricsResetMetrics(cb)
    model.ImplThermalSubsystemMetricsResetMetrics(cb)
end

function thermal_mgmt_service:ImplThermalSubsystemPropertiesGetOptions(cb)
    model.ImplThermalSubsystemPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplThermalSubsystemPropertiesGetPropertiesByOptions(cb)
    model.ImplThermalSubsystemPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplThermalMgmtThermalMgmtSetFanPWM(cb)
    model.ImplThermalMgmtThermalMgmtSetFanPWM(cb)
end

function thermal_mgmt_service:ImplThermalMgmtThermalControlStrategyGetActivatedPolicy(cb)
    model.ImplThermalMgmtThermalControlStrategyGetActivatedPolicy(cb)
end

function thermal_mgmt_service:ImplThermalMgmtPropertiesGetOptions(cb)
    model.ImplThermalMgmtPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplThermalMgmtPropertiesGetPropertiesByOptions(cb)
    model.ImplThermalMgmtPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:ImplCustomTarTempCtrInit(cb)
    model.ImplCustomTarTempCtrInit(cb)
end

function thermal_mgmt_service:CustomTarTempCtrInit(...)
    return model.CustomTarTempCtrInit(...)
end

function thermal_mgmt_service:ImplCustomPidUpdateSensorValue(cb)
    model.ImplCustomPidUpdateSensorValue(cb)
end

function thermal_mgmt_service:CustomPidUpdateSensorValue(...)
    return model.CustomPidUpdateSensorValue(...)
end

function thermal_mgmt_service:ImplCustomPidCountValue(cb)
    model.ImplCustomPidCountValue(cb)
end

function thermal_mgmt_service:CustomPidCountValue(...)
    return model.CustomPidCountValue(...)
end

function thermal_mgmt_service:ImplCustomSetTargetTempConfig(cb)
    model.ImplCustomSetTargetTempConfig(cb)
end

function thermal_mgmt_service:CustomSetTargetTempConfig(...)
    return model.CustomSetTargetTempConfig(...)
end

function thermal_mgmt_service:ImplCustomSetFanConfig(cb)
    model.ImplCustomSetFanConfig(cb)
end

function thermal_mgmt_service:CustomSetFanConfig(...)
    return model.CustomSetFanConfig(...)
end

function thermal_mgmt_service:ImplCustomSetRealTimeTemp(cb)
    model.ImplCustomSetRealTimeTemp(cb)
end

function thermal_mgmt_service:CustomSetRealTimeTemp(...)
    return model.CustomSetRealTimeTemp(...)
end

function thermal_mgmt_service:ImplCustomSetEnvTempConfig(cb)
    model.ImplCustomSetEnvTempConfig(cb)
end

function thermal_mgmt_service:CustomSetEnvTempConfig(...)
    return model.CustomSetEnvTempConfig(...)
end

function thermal_mgmt_service:ImplCustomSetFanAlarmSpeed(cb)
    model.ImplCustomSetFanAlarmSpeed(cb)
end

function thermal_mgmt_service:CustomSetFanAlarmSpeed(...)
    return model.CustomSetFanAlarmSpeed(...)
end

function thermal_mgmt_service:ImplCustomReadInfo(cb)
    model.ImplCustomReadInfo(cb)
end

function thermal_mgmt_service:CustomReadInfo(...)
    return model.CustomReadInfo(...)
end

---@param mdb_object object
---@param MetricName string
---@param TagPath string
function thermal_mgmt_service:FanMetricCollectSignal(mdb_object, MetricName, TagPath)
    self.bus:signal(mdb_object.path, 'bmc.kepler.Metric', 'CollectSignal', 'a{ss}ss', context.get_context() or {},
        MetricName, TagPath)
end

function thermal_mgmt_service:get_bus()
    return self.bus
end

function thermal_mgmt_service:register_ipmi_cmd(ipmi_cmd, cb)
    self.ipmi_cmds[ipmi_cmd.name] = ipmi.register_ipmi_cmd(self.bus, self.service_name, ipmi_cmd,
        cb or self[ipmi_cmd.name])
end

function thermal_mgmt_service:unregister_ipmi_cmd(ipmi_cmd)
    local cmd_obj = self.ipmi_cmds[ipmi_cmd.name]
    if not cmd_obj then
        return
    end

    cmd_obj:unregister()
    self.ipmi_cmds[ipmi_cmd.name] = nil
end

function thermal_mgmt_service:ctor()
    self.ipmi_cmds = {}
    self.signal_slots = {}
    self.name = self.name or thermal_mgmt_service.package
    self.db = open_db(':memory:', datas)

    orm_classes.init(self.db)
    self.bus:request_name(app_base.Service.get_service_name(self.name))
    model.init(self.bus)
    thermal_mgmt_service.bus = self.bus
end

function thermal_mgmt_service:pre_init()
    thermal_mgmt_service.super.pre_init(self)
    self.persist = persist_client.new(self.bus, self.db, self, {
        ['t_fan'] = true,
        ['t_fan_type'] = true,
        ['t_systems_fans'] = true,
        ['t_pumps'] = true,
        ['t_pump'] = true,
        ['t_valves'] = true,
        ['t_valve'] = true,
        ['t_fan_group'] = true,
        ['t_pump_group'] = true,
        ['t_cooling_config'] = true,
        ['t_cooling_fans_config'] = true,
        ['t_cooling_fan'] = true,
        ['t_cooling_requirement'] = true,
        ['t_cooling_policy'] = true,
        ['t_thermal_subsystem'] = true,
        ['t_thermal_configuration'] = true,
        ['t_pwm_channel'] = true,
        ['t_fans'] = true,
        ['t_basic_cooling_config'] = true,
        ['t_fan_group_policy'] = true
    })
    object_manage.set_persist_client(self.persist)
end

function thermal_mgmt_service:init()
    thermal_mgmt_service.super.init(self)
end

return thermal_mgmt_service
