-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local c_object = require 'mc.orm.object'

local orm_classes = {}

function orm_classes.init(db)
    orm_classes.Fan = c_object('Fan')
    orm_classes.FanType = c_object('FanType')
    orm_classes.FanInfo = c_object('FanInfo')
    orm_classes.ThermalConfiguration = c_object('ThermalConfiguration')
    orm_classes.PWMChannel = c_object('PWMChannel')
    orm_classes.SystemsFans = c_object('SystemsFans')
    orm_classes.Fans = c_object('Fans')
    orm_classes.Pumps = c_object('Pumps')
    orm_classes.Pump = c_object('Pump')
    orm_classes.Valves = c_object('Valves')
    orm_classes.Valve = c_object('Valve')
    orm_classes.BasicCoolingConfig = c_object('BasicCoolingConfig')
    orm_classes.FanGroup = c_object('FanGroup')
    orm_classes.FanGroupPolicy = c_object('FanGroupPolicy')
    orm_classes.PumpGroup = c_object('PumpGroup')
    orm_classes.CoolingConfig = c_object('CoolingConfig')
    orm_classes.AirCoolingConfig = c_object('AirCoolingConfig')
    orm_classes.CoolingFan = c_object('CoolingFan')
    orm_classes.CoolingRequirement = c_object('CoolingRequirement')
    orm_classes.CoolingPolicy = c_object('CoolingPolicy')
    orm_classes.ThermalSubsystem = c_object('ThermalSubsystem')
end

return orm_classes
