-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ThermalControlStrategy = {}

---@class ThermalControlStrategy.GetActivatedPolicyRsp
---@field ActivatedPolicy string
local TGetActivatedPolicyRsp = {}
TGetActivatedPolicyRsp.__index = TGetActivatedPolicyRsp
TGetActivatedPolicyRsp.group = {}

local function TGetActivatedPolicyRsp_from_obj(obj)
    return setmetatable(obj, TGetActivatedPolicyRsp)
end

function TGetActivatedPolicyRsp.new(ActivatedPolicy)
    return TGetActivatedPolicyRsp_from_obj({ActivatedPolicy = ActivatedPolicy})
end
---@param obj ThermalControlStrategy.GetActivatedPolicyRsp
function TGetActivatedPolicyRsp:init_from_obj(obj)
    self.ActivatedPolicy = obj.ActivatedPolicy
end

function TGetActivatedPolicyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetActivatedPolicyRsp.group)
end

TGetActivatedPolicyRsp.from_obj = TGetActivatedPolicyRsp_from_obj

TGetActivatedPolicyRsp.proto_property = {'ActivatedPolicy'}

TGetActivatedPolicyRsp.default = {''}

TGetActivatedPolicyRsp.struct = {{name = 'ActivatedPolicy', is_array = false, struct = nil}}

function TGetActivatedPolicyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActivatedPolicy', self.ActivatedPolicy, 'string', false, errs, need_convert)

    TGetActivatedPolicyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetActivatedPolicyRsp.proto_property, errs, need_convert)
    return self
end

function TGetActivatedPolicyRsp:unpack(_)
    return self.ActivatedPolicy
end

ThermalControlStrategy.GetActivatedPolicyRsp = TGetActivatedPolicyRsp

---@class ThermalControlStrategy.GetActivatedPolicyReq
---@field Type string
---@field Mode integer
local TGetActivatedPolicyReq = {}
TGetActivatedPolicyReq.__index = TGetActivatedPolicyReq
TGetActivatedPolicyReq.group = {}

local function TGetActivatedPolicyReq_from_obj(obj)
    return setmetatable(obj, TGetActivatedPolicyReq)
end

function TGetActivatedPolicyReq.new(Type, Mode)
    return TGetActivatedPolicyReq_from_obj({Type = Type, Mode = Mode})
end
---@param obj ThermalControlStrategy.GetActivatedPolicyReq
function TGetActivatedPolicyReq:init_from_obj(obj)
    self.Type = obj.Type
    self.Mode = obj.Mode
end

function TGetActivatedPolicyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetActivatedPolicyReq.group)
end

TGetActivatedPolicyReq.from_obj = TGetActivatedPolicyReq_from_obj

TGetActivatedPolicyReq.proto_property = {'Type', 'Mode'}

TGetActivatedPolicyReq.default = {'', 0}

TGetActivatedPolicyReq.descriptions = {
    [=[Cooling device type.]=], [=[Cooling effective mode, 0: effective factor, 1: algorithm.]=]
}

TGetActivatedPolicyReq.struct = {
    {name = 'Type', is_array = false, struct = nil}, {name = 'Mode', is_array = false, struct = nil}
}

function TGetActivatedPolicyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Mode', self.Mode, 'uint8', false, errs, need_convert)

    TGetActivatedPolicyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetActivatedPolicyReq.proto_property, errs, need_convert)
    return self
end

function TGetActivatedPolicyReq:unpack(_)
    return self.Type, self.Mode
end

ThermalControlStrategy.GetActivatedPolicyReq = TGetActivatedPolicyReq

ThermalControlStrategy.interface = mdb.register_interface('bmc.kepler.Release.ThermalControlStrategy', {}, {
    GetActivatedPolicy = {
        'a{ss}sy', 's', TGetActivatedPolicyReq, TGetActivatedPolicyRsp,
        [=[Get activated policy for a specified cooling device type and mode. For example: getactivatedpolicy Fan 0]=]
    }
}, {})

return ThermalControlStrategy
