-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SOC = {}

---@class SOC.LastResetTime
---@field LastResetTime string
local TLastResetTime = {}
TLastResetTime.__index = TLastResetTime
TLastResetTime.group = {}

local function TLastResetTime_from_obj(obj)
    return setmetatable(obj, TLastResetTime)
end

function TLastResetTime.new(LastResetTime)
    return TLastResetTime_from_obj({LastResetTime = LastResetTime})
end
---@param obj SOC.LastResetTime
function TLastResetTime:init_from_obj(obj)
    self.LastResetTime = obj.LastResetTime
end

function TLastResetTime:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLastResetTime.group)
end

TLastResetTime.from_obj = TLastResetTime_from_obj

TLastResetTime.proto_property = {'LastResetTime'}

TLastResetTime.default = {''}

TLastResetTime.struct = {{name = 'LastResetTime', is_array = false, struct = nil}}

function TLastResetTime:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LastResetTime', self.LastResetTime, 'string', true, errs, need_convert)

    TLastResetTime:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLastResetTime.proto_property, errs, need_convert)
    return self
end

function TLastResetTime:unpack(_)
    return self.LastResetTime
end

SOC.LastResetTime = TLastResetTime

---@class SOC.StartupDuration
---@field StartupDuration integer
local TStartupDuration = {}
TStartupDuration.__index = TStartupDuration
TStartupDuration.group = {}

local function TStartupDuration_from_obj(obj)
    return setmetatable(obj, TStartupDuration)
end

function TStartupDuration.new(StartupDuration)
    return TStartupDuration_from_obj({StartupDuration = StartupDuration})
end
---@param obj SOC.StartupDuration
function TStartupDuration:init_from_obj(obj)
    self.StartupDuration = obj.StartupDuration
end

function TStartupDuration:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartupDuration.group)
end

TStartupDuration.from_obj = TStartupDuration_from_obj

TStartupDuration.proto_property = {'StartupDuration'}

TStartupDuration.default = {0}

TStartupDuration.struct = {{name = 'StartupDuration', is_array = false, struct = nil}}

function TStartupDuration:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StartupDuration', self.StartupDuration, 'uint16', true, errs, need_convert)

    TStartupDuration:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartupDuration.proto_property, errs, need_convert)
    return self
end

function TStartupDuration:unpack(_)
    return self.StartupDuration
end

SOC.StartupDuration = TStartupDuration

---@class SOC.DDRMultiBitECCStatistics
---@field DDRMultiBitECCStatistics integer
local TDDRMultiBitECCStatistics = {}
TDDRMultiBitECCStatistics.__index = TDDRMultiBitECCStatistics
TDDRMultiBitECCStatistics.group = {}

local function TDDRMultiBitECCStatistics_from_obj(obj)
    return setmetatable(obj, TDDRMultiBitECCStatistics)
end

function TDDRMultiBitECCStatistics.new(DDRMultiBitECCStatistics)
    return TDDRMultiBitECCStatistics_from_obj({DDRMultiBitECCStatistics = DDRMultiBitECCStatistics})
end
---@param obj SOC.DDRMultiBitECCStatistics
function TDDRMultiBitECCStatistics:init_from_obj(obj)
    self.DDRMultiBitECCStatistics = obj.DDRMultiBitECCStatistics
end

function TDDRMultiBitECCStatistics:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDDRMultiBitECCStatistics.group)
end

TDDRMultiBitECCStatistics.from_obj = TDDRMultiBitECCStatistics_from_obj

TDDRMultiBitECCStatistics.proto_property = {'DDRMultiBitECCStatistics'}

TDDRMultiBitECCStatistics.default = {0}

TDDRMultiBitECCStatistics.struct = {{name = 'DDRMultiBitECCStatistics', is_array = false, struct = nil}}

function TDDRMultiBitECCStatistics:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DDRMultiBitECCStatistics', self.DDRMultiBitECCStatistics, 'uint32', true, errs,
        need_convert)

    TDDRMultiBitECCStatistics:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDDRMultiBitECCStatistics.proto_property, errs, need_convert)
    return self
end

function TDDRMultiBitECCStatistics:unpack(_)
    return self.DDRMultiBitECCStatistics
end

SOC.DDRMultiBitECCStatistics = TDDRMultiBitECCStatistics

---@class SOC.DDRSingleBitECCStatistics
---@field DDRSingleBitECCStatistics integer
local TDDRSingleBitECCStatistics = {}
TDDRSingleBitECCStatistics.__index = TDDRSingleBitECCStatistics
TDDRSingleBitECCStatistics.group = {}

local function TDDRSingleBitECCStatistics_from_obj(obj)
    return setmetatable(obj, TDDRSingleBitECCStatistics)
end

function TDDRSingleBitECCStatistics.new(DDRSingleBitECCStatistics)
    return TDDRSingleBitECCStatistics_from_obj({DDRSingleBitECCStatistics = DDRSingleBitECCStatistics})
end
---@param obj SOC.DDRSingleBitECCStatistics
function TDDRSingleBitECCStatistics:init_from_obj(obj)
    self.DDRSingleBitECCStatistics = obj.DDRSingleBitECCStatistics
end

function TDDRSingleBitECCStatistics:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDDRSingleBitECCStatistics.group)
end

TDDRSingleBitECCStatistics.from_obj = TDDRSingleBitECCStatistics_from_obj

TDDRSingleBitECCStatistics.proto_property = {'DDRSingleBitECCStatistics'}

TDDRSingleBitECCStatistics.default = {0}

TDDRSingleBitECCStatistics.struct = {{name = 'DDRSingleBitECCStatistics', is_array = false, struct = nil}}

function TDDRSingleBitECCStatistics:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DDRSingleBitECCStatistics', self.DDRSingleBitECCStatistics, 'uint32', true, errs,
        need_convert)

    TDDRSingleBitECCStatistics:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDDRSingleBitECCStatistics.proto_property, errs, need_convert)
    return self
end

function TDDRSingleBitECCStatistics:unpack(_)
    return self.DDRSingleBitECCStatistics
end

SOC.DDRSingleBitECCStatistics = TDDRSingleBitECCStatistics

---@class SOC.DDRSelfTestResult
---@field DDRSelfTestResult integer
local TDDRSelfTestResult = {}
TDDRSelfTestResult.__index = TDDRSelfTestResult
TDDRSelfTestResult.group = {}

local function TDDRSelfTestResult_from_obj(obj)
    return setmetatable(obj, TDDRSelfTestResult)
end

function TDDRSelfTestResult.new(DDRSelfTestResult)
    return TDDRSelfTestResult_from_obj({DDRSelfTestResult = DDRSelfTestResult})
end
---@param obj SOC.DDRSelfTestResult
function TDDRSelfTestResult:init_from_obj(obj)
    self.DDRSelfTestResult = obj.DDRSelfTestResult
end

function TDDRSelfTestResult:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDDRSelfTestResult.group)
end

TDDRSelfTestResult.from_obj = TDDRSelfTestResult_from_obj

TDDRSelfTestResult.proto_property = {'DDRSelfTestResult'}

TDDRSelfTestResult.default = {0}

TDDRSelfTestResult.struct = {{name = 'DDRSelfTestResult', is_array = false, struct = nil}}

function TDDRSelfTestResult:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DDRSelfTestResult', self.DDRSelfTestResult, 'uint8', true, errs, need_convert)

    TDDRSelfTestResult:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDDRSelfTestResult.proto_property, errs, need_convert)
    return self
end

function TDDRSelfTestResult:unpack(_)
    return self.DDRSelfTestResult
end

SOC.DDRSelfTestResult = TDDRSelfTestResult

---@class SOC.ResetType
---@field ResetType integer
local TResetType = {}
TResetType.__index = TResetType
TResetType.group = {}

local function TResetType_from_obj(obj)
    return setmetatable(obj, TResetType)
end

function TResetType.new(ResetType)
    return TResetType_from_obj({ResetType = ResetType})
end
---@param obj SOC.ResetType
function TResetType:init_from_obj(obj)
    self.ResetType = obj.ResetType
end

function TResetType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetType.group)
end

TResetType.from_obj = TResetType_from_obj

TResetType.proto_property = {'ResetType'}

TResetType.default = {0}

TResetType.struct = {{name = 'ResetType', is_array = false, struct = nil}}

function TResetType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetType', self.ResetType, 'uint8', true, errs, need_convert)

    TResetType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetType.proto_property, errs, need_convert)
    return self
end

function TResetType:unpack(_)
    return self.ResetType
end

SOC.ResetType = TResetType

---@class SOC.DIEID
---@field DIEID string
local TDIEID = {}
TDIEID.__index = TDIEID
TDIEID.group = {}

local function TDIEID_from_obj(obj)
    return setmetatable(obj, TDIEID)
end

function TDIEID.new(DIEID)
    return TDIEID_from_obj({DIEID = DIEID})
end
---@param obj SOC.DIEID
function TDIEID:init_from_obj(obj)
    self.DIEID = obj.DIEID
end

function TDIEID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDIEID.group)
end

TDIEID.from_obj = TDIEID_from_obj

TDIEID.proto_property = {'DIEID'}

TDIEID.default = {''}

TDIEID.struct = {{name = 'DIEID', is_array = false, struct = nil}}

function TDIEID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DIEID', self.DIEID, 'string', true, errs, need_convert)

    TDIEID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDIEID.proto_property, errs, need_convert)
    return self
end

function TDIEID:unpack(_)
    return self.DIEID
end

SOC.DIEID = TDIEID

---@class SOC.Designator
---@field Designator string
local TDesignator = {}
TDesignator.__index = TDesignator
TDesignator.group = {}

local function TDesignator_from_obj(obj)
    return setmetatable(obj, TDesignator)
end

function TDesignator.new(Designator)
    return TDesignator_from_obj({Designator = Designator})
end
---@param obj SOC.Designator
function TDesignator:init_from_obj(obj)
    self.Designator = obj.Designator
end

function TDesignator:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDesignator.group)
end

TDesignator.from_obj = TDesignator_from_obj

TDesignator.proto_property = {'Designator'}

TDesignator.default = {''}

TDesignator.struct = {{name = 'Designator', is_array = false, struct = nil}}

function TDesignator:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Designator', self.Designator, 'string', true, errs, need_convert)

    TDesignator:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDesignator.proto_property, errs, need_convert)
    return self
end

function TDesignator:unpack(_)
    return self.Designator
end

SOC.Designator = TDesignator

---@class SOC.Version
---@field Version string
local TVersion = {}
TVersion.__index = TVersion
TVersion.group = {}

local function TVersion_from_obj(obj)
    return setmetatable(obj, TVersion)
end

function TVersion.new(Version)
    return TVersion_from_obj({Version = Version})
end
---@param obj SOC.Version
function TVersion:init_from_obj(obj)
    self.Version = obj.Version
end

function TVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVersion.group)
end

TVersion.from_obj = TVersion_from_obj

TVersion.proto_property = {'Version'}

TVersion.default = {''}

TVersion.struct = {{name = 'Version', is_array = false, struct = nil}}

function TVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Version', self.Version, 'string', true, errs, need_convert)

    TVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVersion.proto_property, errs, need_convert)
    return self
end

function TVersion:unpack(_)
    return self.Version
end

SOC.Version = TVersion

---@class SOC.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj SOC.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', true, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

SOC.Name = TName

---@class SOC.TemperatureThreshold
---@field TemperatureThreshold integer
local TTemperatureThreshold = {}
TTemperatureThreshold.__index = TTemperatureThreshold
TTemperatureThreshold.group = {}

local function TTemperatureThreshold_from_obj(obj)
    return setmetatable(obj, TTemperatureThreshold)
end

function TTemperatureThreshold.new(TemperatureThreshold)
    return TTemperatureThreshold_from_obj({TemperatureThreshold = TemperatureThreshold})
end
---@param obj SOC.TemperatureThreshold
function TTemperatureThreshold:init_from_obj(obj)
    self.TemperatureThreshold = obj.TemperatureThreshold
end

function TTemperatureThreshold:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureThreshold.group)
end

TTemperatureThreshold.from_obj = TTemperatureThreshold_from_obj

TTemperatureThreshold.proto_property = {'TemperatureThreshold'}

TTemperatureThreshold.default = {0}

TTemperatureThreshold.struct = {{name = 'TemperatureThreshold', is_array = false, struct = nil}}

function TTemperatureThreshold:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureThreshold', self.TemperatureThreshold, 'uint16', true, errs, need_convert)

    TTemperatureThreshold:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureThreshold.proto_property, errs, need_convert)
    return self
end

function TTemperatureThreshold:unpack(_)
    return self.TemperatureThreshold
end

SOC.TemperatureThreshold = TTemperatureThreshold

---@class SOC.Temperature
---@field Temperature integer
local TTemperature = {}
TTemperature.__index = TTemperature
TTemperature.group = {}

local function TTemperature_from_obj(obj)
    return setmetatable(obj, TTemperature)
end

function TTemperature.new(Temperature)
    return TTemperature_from_obj({Temperature = Temperature})
end
---@param obj SOC.Temperature
function TTemperature:init_from_obj(obj)
    self.Temperature = obj.Temperature
end

function TTemperature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperature.group)
end

TTemperature.from_obj = TTemperature_from_obj

TTemperature.proto_property = {'Temperature'}

TTemperature.default = {0}

TTemperature.struct = {{name = 'Temperature', is_array = false, struct = nil}}

function TTemperature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Temperature', self.Temperature, 'uint16', true, errs, need_convert)

    TTemperature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperature.proto_property, errs, need_convert)
    return self
end

function TTemperature:unpack(_)
    return self.Temperature
end

SOC.Temperature = TTemperature

---@class SOC.PCIeControllerEnabled
---@field PCIeControllerEnabled boolean
local TPCIeControllerEnabled = {}
TPCIeControllerEnabled.__index = TPCIeControllerEnabled
TPCIeControllerEnabled.group = {}

local function TPCIeControllerEnabled_from_obj(obj)
    return setmetatable(obj, TPCIeControllerEnabled)
end

function TPCIeControllerEnabled.new(PCIeControllerEnabled)
    return TPCIeControllerEnabled_from_obj({PCIeControllerEnabled = PCIeControllerEnabled})
end
---@param obj SOC.PCIeControllerEnabled
function TPCIeControllerEnabled:init_from_obj(obj)
    self.PCIeControllerEnabled = obj.PCIeControllerEnabled
end

function TPCIeControllerEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPCIeControllerEnabled.group)
end

TPCIeControllerEnabled.from_obj = TPCIeControllerEnabled_from_obj

TPCIeControllerEnabled.proto_property = {'PCIeControllerEnabled'}

TPCIeControllerEnabled.default = {false}

TPCIeControllerEnabled.struct = {{name = 'PCIeControllerEnabled', is_array = false, struct = nil}}

function TPCIeControllerEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PCIeControllerEnabled', self.PCIeControllerEnabled, 'bool', false, errs, need_convert)

    TPCIeControllerEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPCIeControllerEnabled.proto_property, errs, need_convert)
    return self
end

function TPCIeControllerEnabled:unpack(_)
    return self.PCIeControllerEnabled
end

SOC.PCIeControllerEnabled = TPCIeControllerEnabled

---@class SOC.BlackBoxEnabled
---@field BlackBoxEnabled boolean
local TBlackBoxEnabled = {}
TBlackBoxEnabled.__index = TBlackBoxEnabled
TBlackBoxEnabled.group = {}

local function TBlackBoxEnabled_from_obj(obj)
    return setmetatable(obj, TBlackBoxEnabled)
end

function TBlackBoxEnabled.new(BlackBoxEnabled)
    return TBlackBoxEnabled_from_obj({BlackBoxEnabled = BlackBoxEnabled})
end
---@param obj SOC.BlackBoxEnabled
function TBlackBoxEnabled:init_from_obj(obj)
    self.BlackBoxEnabled = obj.BlackBoxEnabled
end

function TBlackBoxEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBlackBoxEnabled.group)
end

TBlackBoxEnabled.from_obj = TBlackBoxEnabled_from_obj

TBlackBoxEnabled.proto_property = {'BlackBoxEnabled'}

TBlackBoxEnabled.default = {false}

TBlackBoxEnabled.struct = {{name = 'BlackBoxEnabled', is_array = false, struct = nil}}

function TBlackBoxEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BlackBoxEnabled', self.BlackBoxEnabled, 'bool', false, errs, need_convert)

    TBlackBoxEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBlackBoxEnabled.proto_property, errs, need_convert)
    return self
end

function TBlackBoxEnabled:unpack(_)
    return self.BlackBoxEnabled
end

SOC.BlackBoxEnabled = TBlackBoxEnabled

SOC.interface = mdb.register_interface('bmc.kepler.Managers.SOC', {
    BlackBoxEnabled = {'b', nil, false, nil, false},
    PCIeControllerEnabled = {'b', nil, false, nil, false},
    Temperature = {'q', nil, true, nil, false},
    TemperatureThreshold = {'q', nil, true, nil, false},
    Name = {'s', {}, true, nil, false},
    Version = {'s', {}, true, nil, false},
    Designator = {'s', {}, true, nil, false},
    DIEID = {'s', {}, true, nil, false},
    ResetType = {'y', {}, true, nil, false},
    DDRSelfTestResult = {'y', nil, true, nil, false},
    DDRSingleBitECCStatistics = {'u', {}, true, nil, false},
    DDRMultiBitECCStatistics = {'u', {}, true, nil, false},
    StartupDuration = {'q', {}, true, nil, false},
    LastResetTime = {'s', {}, true, nil, false}
}, {}, {})

return SOC
