-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Pump = {}

---@class Pump.Status
---@field Status integer
local TStatus = {}
TStatus.__index = TStatus
TStatus.group = {}

local function TStatus_from_obj(obj)
    return setmetatable(obj, TStatus)
end

function TStatus.new(Status)
    return TStatus_from_obj({Status = Status})
end
---@param obj Pump.Status
function TStatus:init_from_obj(obj)
    self.Status = obj.Status
end

function TStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStatus.group)
end

TStatus.from_obj = TStatus_from_obj

TStatus.proto_property = {'Status'}

TStatus.default = {0}

TStatus.struct = {{name = 'Status', is_array = false, struct = nil}}

function TStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', true, errs, need_convert)

    TStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStatus.proto_property, errs, need_convert)
    return self
end

function TStatus:unpack(_)
    return self.Status
end

Pump.Status = TStatus

---@class Pump.Presence
---@field Presence integer
local TPresence = {}
TPresence.__index = TPresence
TPresence.group = {}

local function TPresence_from_obj(obj)
    return setmetatable(obj, TPresence)
end

function TPresence.new(Presence)
    return TPresence_from_obj({Presence = Presence})
end
---@param obj Pump.Presence
function TPresence:init_from_obj(obj)
    self.Presence = obj.Presence
end

function TPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPresence.group)
end

TPresence.from_obj = TPresence_from_obj

TPresence.proto_property = {'Presence'}

TPresence.default = {0}

TPresence.struct = {{name = 'Presence', is_array = false, struct = nil}}

function TPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Presence', self.Presence, 'uint8', true, errs, need_convert)

    TPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPresence.proto_property, errs, need_convert)
    return self
end

function TPresence:unpack(_)
    return self.Presence
end

Pump.Presence = TPresence

---@class Pump.MaxSpeedRPM
---@field MaxSpeedRPM integer
local TMaxSpeedRPM = {}
TMaxSpeedRPM.__index = TMaxSpeedRPM
TMaxSpeedRPM.group = {}

local function TMaxSpeedRPM_from_obj(obj)
    return setmetatable(obj, TMaxSpeedRPM)
end

function TMaxSpeedRPM.new(MaxSpeedRPM)
    return TMaxSpeedRPM_from_obj({MaxSpeedRPM = MaxSpeedRPM})
end
---@param obj Pump.MaxSpeedRPM
function TMaxSpeedRPM:init_from_obj(obj)
    self.MaxSpeedRPM = obj.MaxSpeedRPM
end

function TMaxSpeedRPM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxSpeedRPM.group)
end

TMaxSpeedRPM.from_obj = TMaxSpeedRPM_from_obj

TMaxSpeedRPM.proto_property = {'MaxSpeedRPM'}

TMaxSpeedRPM.default = {0}

TMaxSpeedRPM.struct = {{name = 'MaxSpeedRPM', is_array = false, struct = nil}}

function TMaxSpeedRPM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxSpeedRPM', self.MaxSpeedRPM, 'uint32', true, errs, need_convert)

    TMaxSpeedRPM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxSpeedRPM.proto_property, errs, need_convert)
    return self
end

function TMaxSpeedRPM:unpack(_)
    return self.MaxSpeedRPM
end

Pump.MaxSpeedRPM = TMaxSpeedRPM

---@class Pump.SpeedRPM
---@field SpeedRPM integer
local TSpeedRPM = {}
TSpeedRPM.__index = TSpeedRPM
TSpeedRPM.group = {}

local function TSpeedRPM_from_obj(obj)
    return setmetatable(obj, TSpeedRPM)
end

function TSpeedRPM.new(SpeedRPM)
    return TSpeedRPM_from_obj({SpeedRPM = SpeedRPM})
end
---@param obj Pump.SpeedRPM
function TSpeedRPM:init_from_obj(obj)
    self.SpeedRPM = obj.SpeedRPM
end

function TSpeedRPM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSpeedRPM.group)
end

TSpeedRPM.from_obj = TSpeedRPM_from_obj

TSpeedRPM.proto_property = {'SpeedRPM'}

TSpeedRPM.default = {0}

TSpeedRPM.struct = {{name = 'SpeedRPM', is_array = false, struct = nil}}

function TSpeedRPM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SpeedRPM', self.SpeedRPM, 'uint16', true, errs, need_convert)

    TSpeedRPM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSpeedRPM.proto_property, errs, need_convert)
    return self
end

function TSpeedRPM:unpack(_)
    return self.SpeedRPM
end

Pump.SpeedRPM = TSpeedRPM

---@class Pump.MaxSupportedPWM
---@field MaxSupportedPWM integer
local TMaxSupportedPWM = {}
TMaxSupportedPWM.__index = TMaxSupportedPWM
TMaxSupportedPWM.group = {}

local function TMaxSupportedPWM_from_obj(obj)
    return setmetatable(obj, TMaxSupportedPWM)
end

function TMaxSupportedPWM.new(MaxSupportedPWM)
    return TMaxSupportedPWM_from_obj({MaxSupportedPWM = MaxSupportedPWM})
end
---@param obj Pump.MaxSupportedPWM
function TMaxSupportedPWM:init_from_obj(obj)
    self.MaxSupportedPWM = obj.MaxSupportedPWM
end

function TMaxSupportedPWM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxSupportedPWM.group)
end

TMaxSupportedPWM.from_obj = TMaxSupportedPWM_from_obj

TMaxSupportedPWM.proto_property = {'MaxSupportedPWM'}

TMaxSupportedPWM.default = {0}

TMaxSupportedPWM.struct = {{name = 'MaxSupportedPWM', is_array = false, struct = nil}}

function TMaxSupportedPWM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxSupportedPWM', self.MaxSupportedPWM, 'uint32', true, errs, need_convert)

    TMaxSupportedPWM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxSupportedPWM.proto_property, errs, need_convert)
    return self
end

function TMaxSupportedPWM:unpack(_)
    return self.MaxSupportedPWM
end

Pump.MaxSupportedPWM = TMaxSupportedPWM

---@class Pump.ActualPWM
---@field ActualPWM number
local TActualPWM = {}
TActualPWM.__index = TActualPWM
TActualPWM.group = {}

local function TActualPWM_from_obj(obj)
    return setmetatable(obj, TActualPWM)
end

function TActualPWM.new(ActualPWM)
    return TActualPWM_from_obj({ActualPWM = ActualPWM})
end
---@param obj Pump.ActualPWM
function TActualPWM:init_from_obj(obj)
    self.ActualPWM = obj.ActualPWM
end

function TActualPWM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActualPWM.group)
end

TActualPWM.from_obj = TActualPWM_from_obj

TActualPWM.proto_property = {'ActualPWM'}

TActualPWM.default = {0}

TActualPWM.struct = {{name = 'ActualPWM', is_array = false, struct = nil}}

function TActualPWM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActualPWM', self.ActualPWM, 'double', true, errs, need_convert)

    TActualPWM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActualPWM.proto_property, errs, need_convert)
    return self
end

function TActualPWM:unpack(_)
    return self.ActualPWM
end

Pump.ActualPWM = TActualPWM

---@class Pump.ExpectedPWM
---@field ExpectedPWM number
local TExpectedPWM = {}
TExpectedPWM.__index = TExpectedPWM
TExpectedPWM.group = {}

local function TExpectedPWM_from_obj(obj)
    return setmetatable(obj, TExpectedPWM)
end

function TExpectedPWM.new(ExpectedPWM)
    return TExpectedPWM_from_obj({ExpectedPWM = ExpectedPWM})
end
---@param obj Pump.ExpectedPWM
function TExpectedPWM:init_from_obj(obj)
    self.ExpectedPWM = obj.ExpectedPWM
end

function TExpectedPWM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExpectedPWM.group)
end

TExpectedPWM.from_obj = TExpectedPWM_from_obj

TExpectedPWM.proto_property = {'ExpectedPWM'}

TExpectedPWM.default = {0}

TExpectedPWM.struct = {{name = 'ExpectedPWM', is_array = false, struct = nil}}

function TExpectedPWM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ExpectedPWM', self.ExpectedPWM, 'double', true, errs, need_convert)

    TExpectedPWM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExpectedPWM.proto_property, errs, need_convert)
    return self
end

function TExpectedPWM:unpack(_)
    return self.ExpectedPWM
end

Pump.ExpectedPWM = TExpectedPWM

---@class Pump.PartNumber
---@field PartNumber string
local TPartNumber = {}
TPartNumber.__index = TPartNumber
TPartNumber.group = {}

local function TPartNumber_from_obj(obj)
    return setmetatable(obj, TPartNumber)
end

function TPartNumber.new(PartNumber)
    return TPartNumber_from_obj({PartNumber = PartNumber})
end
---@param obj Pump.PartNumber
function TPartNumber:init_from_obj(obj)
    self.PartNumber = obj.PartNumber
end

function TPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPartNumber.group)
end

TPartNumber.from_obj = TPartNumber_from_obj

TPartNumber.proto_property = {'PartNumber'}

TPartNumber.default = {''}

TPartNumber.struct = {{name = 'PartNumber', is_array = false, struct = nil}}

function TPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PartNumber', self.PartNumber, 'string', true, errs, need_convert)

    TPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPartNumber.proto_property, errs, need_convert)
    return self
end

function TPartNumber:unpack(_)
    return self.PartNumber
end

Pump.PartNumber = TPartNumber

---@class Pump.Model
---@field Model string
local TModel = {}
TModel.__index = TModel
TModel.group = {}

local function TModel_from_obj(obj)
    return setmetatable(obj, TModel)
end

function TModel.new(Model)
    return TModel_from_obj({Model = Model})
end
---@param obj Pump.Model
function TModel:init_from_obj(obj)
    self.Model = obj.Model
end

function TModel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModel.group)
end

TModel.from_obj = TModel_from_obj

TModel.proto_property = {'Model'}

TModel.default = {''}

TModel.struct = {{name = 'Model', is_array = false, struct = nil}}

function TModel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Model', self.Model, 'string', true, errs, need_convert)

    TModel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModel.proto_property, errs, need_convert)
    return self
end

function TModel:unpack(_)
    return self.Model
end

Pump.Model = TModel

---@class Pump.Slot
---@field Slot integer
local TSlot = {}
TSlot.__index = TSlot
TSlot.group = {}

local function TSlot_from_obj(obj)
    return setmetatable(obj, TSlot)
end

function TSlot.new(Slot)
    return TSlot_from_obj({Slot = Slot})
end
---@param obj Pump.Slot
function TSlot:init_from_obj(obj)
    self.Slot = obj.Slot
end

function TSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlot.group)
end

TSlot.from_obj = TSlot_from_obj

TSlot.proto_property = {'Slot'}

TSlot.default = {0}

TSlot.struct = {{name = 'Slot', is_array = false, struct = nil}}

function TSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Slot', self.Slot, 'uint8', true, errs, need_convert)

    TSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlot.proto_property, errs, need_convert)
    return self
end

function TSlot:unpack(_)
    return self.Slot
end

Pump.Slot = TSlot

---@class Pump.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj Pump.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint16', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

Pump.Id = TId

Pump.interface = mdb.register_interface('bmc.kepler.Systems.Pump', {
    Id = {'q', {'CONST'}, true, nil, false},
    Slot = {'y', {'CONST'}, true, nil, false},
    Model = {'s', {'CONST'}, true, nil, false},
    PartNumber = {'s', {}, true, nil, false},
    ExpectedPWM = {'d', {}, true, nil, false},
    ActualPWM = {'d', {}, true, nil, false},
    MaxSupportedPWM = {'u', {}, true, nil, false},
    SpeedRPM = {'q', {'VOLATILE'}, true, nil, false},
    MaxSpeedRPM = {'u', {}, true, nil, false},
    Presence = {'y', nil, true, nil, false},
    Status = {'y', nil, true, nil, false}
}, {}, {})

return Pump
