-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local LiquidCoolingConfig = {}

---@class LiquidCoolingConfig.ActiveAlgorithm
---@field ActiveAlgorithm string
local TActiveAlgorithm = {}
TActiveAlgorithm.__index = TActiveAlgorithm
TActiveAlgorithm.group = {}

local function TActiveAlgorithm_from_obj(obj)
    return setmetatable(obj, TActiveAlgorithm)
end

function TActiveAlgorithm.new(ActiveAlgorithm)
    return TActiveAlgorithm_from_obj({ActiveAlgorithm = ActiveAlgorithm or [=[N/A]=]})
end
---@param obj LiquidCoolingConfig.ActiveAlgorithm
function TActiveAlgorithm:init_from_obj(obj)
    self.ActiveAlgorithm = obj.ActiveAlgorithm or [=[N/A]=]
end

function TActiveAlgorithm:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActiveAlgorithm.group)
end

TActiveAlgorithm.from_obj = TActiveAlgorithm_from_obj

TActiveAlgorithm.proto_property = {'ActiveAlgorithm'}

TActiveAlgorithm.default = {''}

TActiveAlgorithm.struct = {{name = 'ActiveAlgorithm', is_array = false, struct = nil}}

function TActiveAlgorithm:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActiveAlgorithm', self.ActiveAlgorithm, 'string', true, errs, need_convert)

    TActiveAlgorithm:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActiveAlgorithm.proto_property, errs, need_convert)
    return self
end

function TActiveAlgorithm:unpack(_)
    return self.ActiveAlgorithm
end

LiquidCoolingConfig.ActiveAlgorithm = TActiveAlgorithm

---@class LiquidCoolingConfig.LevelPercentRange
---@field LevelPercentRange integer[]
local TLevelPercentRange = {}
TLevelPercentRange.__index = TLevelPercentRange
TLevelPercentRange.group = {}

local function TLevelPercentRange_from_obj(obj)
    return setmetatable(obj, TLevelPercentRange)
end

function TLevelPercentRange.new(LevelPercentRange)
    return TLevelPercentRange_from_obj({LevelPercentRange = LevelPercentRange})
end
---@param obj LiquidCoolingConfig.LevelPercentRange
function TLevelPercentRange:init_from_obj(obj)
    self.LevelPercentRange = obj.LevelPercentRange
end

function TLevelPercentRange:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLevelPercentRange.group)
end

TLevelPercentRange.from_obj = TLevelPercentRange_from_obj

TLevelPercentRange.proto_property = {'LevelPercentRange'}

TLevelPercentRange.default = {{}}

TLevelPercentRange.struct = {{name = 'LevelPercentRange', is_array = true, struct = nil}}

function TLevelPercentRange:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'LevelPercentRange', self.LevelPercentRange, 'uint8', true, errs, need_convert)

    TLevelPercentRange:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLevelPercentRange.proto_property, errs, need_convert)
    return self
end

function TLevelPercentRange:unpack(_)
    return self.LevelPercentRange
end

LiquidCoolingConfig.LevelPercentRange = TLevelPercentRange

---@class LiquidCoolingConfig.ManualLevel
---@field ManualLevel integer
local TManualLevel = {}
TManualLevel.__index = TManualLevel
TManualLevel.group = {}

local function TManualLevel_from_obj(obj)
    return setmetatable(obj, TManualLevel)
end

function TManualLevel.new(ManualLevel)
    return TManualLevel_from_obj({ManualLevel = ManualLevel or 25})
end
---@param obj LiquidCoolingConfig.ManualLevel
function TManualLevel:init_from_obj(obj)
    self.ManualLevel = obj.ManualLevel or 25
end

function TManualLevel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManualLevel.group)
end

TManualLevel.from_obj = TManualLevel_from_obj

TManualLevel.proto_property = {'ManualLevel'}

TManualLevel.default = {0}

TManualLevel.struct = {{name = 'ManualLevel', is_array = false, struct = nil}}

function TManualLevel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManualLevel', self.ManualLevel, 'uint8', true, errs, need_convert)

    TManualLevel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManualLevel.proto_property, errs, need_convert)
    return self
end

function TManualLevel:unpack(_)
    return self.ManualLevel
end

LiquidCoolingConfig.ManualLevel = TManualLevel

---@class LiquidCoolingConfig.TimeOut
---@field TimeOut integer
local TTimeOut = {}
TTimeOut.__index = TTimeOut
TTimeOut.group = {}

local function TTimeOut_from_obj(obj)
    return setmetatable(obj, TTimeOut)
end

function TTimeOut.new(TimeOut)
    return TTimeOut_from_obj({TimeOut = TimeOut or 30})
end
---@param obj LiquidCoolingConfig.TimeOut
function TTimeOut:init_from_obj(obj)
    self.TimeOut = obj.TimeOut or 30
end

function TTimeOut:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTimeOut.group)
end

TTimeOut.from_obj = TTimeOut_from_obj

TTimeOut.proto_property = {'TimeOut'}

TTimeOut.default = {0}

TTimeOut.struct = {{name = 'TimeOut', is_array = false, struct = nil}}

function TTimeOut:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TimeOut', self.TimeOut, 'uint32', true, errs, need_convert)

    TTimeOut:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTimeOut.proto_property, errs, need_convert)
    return self
end

function TTimeOut:unpack(_)
    return self.TimeOut
end

LiquidCoolingConfig.TimeOut = TTimeOut

---@class LiquidCoolingConfig.CtrlMode
---@field CtrlMode string
local TCtrlMode = {}
TCtrlMode.__index = TCtrlMode
TCtrlMode.group = {}

local function TCtrlMode_from_obj(obj)
    return setmetatable(obj, TCtrlMode)
end

function TCtrlMode.new(CtrlMode)
    return TCtrlMode_from_obj({CtrlMode = CtrlMode or [=[Auto]=]})
end
---@param obj LiquidCoolingConfig.CtrlMode
function TCtrlMode:init_from_obj(obj)
    self.CtrlMode = obj.CtrlMode or [=[Auto]=]
end

function TCtrlMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCtrlMode.group)
end

TCtrlMode.from_obj = TCtrlMode_from_obj

TCtrlMode.proto_property = {'CtrlMode'}

TCtrlMode.default = {''}

TCtrlMode.struct = {{name = 'CtrlMode', is_array = false, struct = nil}}

function TCtrlMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CtrlMode', self.CtrlMode, 'string', true, errs, need_convert)

    if self.CtrlMode ~= nil then
        validate.Enum(prefix .. 'CtrlMode', self.CtrlMode, '', {'Auto', 'Manual', 'Mixed'}, errs, need_convert)
    end

    TCtrlMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCtrlMode.proto_property, errs, need_convert)
    return self
end

function TCtrlMode:unpack(_)
    return self.CtrlMode
end

LiquidCoolingConfig.CtrlMode = TCtrlMode

---@class LiquidCoolingConfig.SetCtrlModeRsp
local TSetCtrlModeRsp = {}
TSetCtrlModeRsp.__index = TSetCtrlModeRsp
TSetCtrlModeRsp.group = {}

local function TSetCtrlModeRsp_from_obj(obj)
    return setmetatable(obj, TSetCtrlModeRsp)
end

function TSetCtrlModeRsp.new()
    return TSetCtrlModeRsp_from_obj({})
end
---@param obj LiquidCoolingConfig.SetCtrlModeRsp
function TSetCtrlModeRsp:init_from_obj(obj)

end

function TSetCtrlModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCtrlModeRsp.group)
end

TSetCtrlModeRsp.from_obj = TSetCtrlModeRsp_from_obj

TSetCtrlModeRsp.proto_property = {}

TSetCtrlModeRsp.default = {}

TSetCtrlModeRsp.struct = {}

function TSetCtrlModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetCtrlModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCtrlModeRsp.proto_property, errs, need_convert)
    return self
end

function TSetCtrlModeRsp:unpack(_)
end

LiquidCoolingConfig.SetCtrlModeRsp = TSetCtrlModeRsp

---@class LiquidCoolingConfig.SetCtrlModeReq
---@field CtrlMode string
---@field Timeout integer
local TSetCtrlModeReq = {}
TSetCtrlModeReq.__index = TSetCtrlModeReq
TSetCtrlModeReq.group = {}

local function TSetCtrlModeReq_from_obj(obj)
    return setmetatable(obj, TSetCtrlModeReq)
end

function TSetCtrlModeReq.new(CtrlMode, Timeout)
    return TSetCtrlModeReq_from_obj({CtrlMode = CtrlMode, Timeout = Timeout})
end
---@param obj LiquidCoolingConfig.SetCtrlModeReq
function TSetCtrlModeReq:init_from_obj(obj)
    self.CtrlMode = obj.CtrlMode
    self.Timeout = obj.Timeout
end

function TSetCtrlModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCtrlModeReq.group)
end

TSetCtrlModeReq.from_obj = TSetCtrlModeReq_from_obj

TSetCtrlModeReq.proto_property = {'CtrlMode', 'Timeout'}

TSetCtrlModeReq.default = {'', 0}

TSetCtrlModeReq.struct = {
    {name = 'CtrlMode', is_array = false, struct = nil}, {name = 'Timeout', is_array = false, struct = nil}
}

function TSetCtrlModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CtrlMode', self.CtrlMode, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Timeout', self.Timeout, 'uint32', false, errs, need_convert)

    TSetCtrlModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCtrlModeReq.proto_property, errs, need_convert)
    return self
end

function TSetCtrlModeReq:unpack(_)
    return self.CtrlMode, self.Timeout
end

LiquidCoolingConfig.SetCtrlModeReq = TSetCtrlModeReq

---@class LiquidCoolingConfig.SetManualLevelRsp
local TSetManualLevelRsp = {}
TSetManualLevelRsp.__index = TSetManualLevelRsp
TSetManualLevelRsp.group = {}

local function TSetManualLevelRsp_from_obj(obj)
    return setmetatable(obj, TSetManualLevelRsp)
end

function TSetManualLevelRsp.new()
    return TSetManualLevelRsp_from_obj({})
end
---@param obj LiquidCoolingConfig.SetManualLevelRsp
function TSetManualLevelRsp:init_from_obj(obj)

end

function TSetManualLevelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetManualLevelRsp.group)
end

TSetManualLevelRsp.from_obj = TSetManualLevelRsp_from_obj

TSetManualLevelRsp.proto_property = {}

TSetManualLevelRsp.default = {}

TSetManualLevelRsp.struct = {}

function TSetManualLevelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetManualLevelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetManualLevelRsp.proto_property, errs, need_convert)
    return self
end

function TSetManualLevelRsp:unpack(_)
end

LiquidCoolingConfig.SetManualLevelRsp = TSetManualLevelRsp

---@class LiquidCoolingConfig.SetManualLevelReq
---@field UnitId integer
---@field Level integer
local TSetManualLevelReq = {}
TSetManualLevelReq.__index = TSetManualLevelReq
TSetManualLevelReq.group = {}

local function TSetManualLevelReq_from_obj(obj)
    return setmetatable(obj, TSetManualLevelReq)
end

function TSetManualLevelReq.new(UnitId, Level)
    return TSetManualLevelReq_from_obj({UnitId = UnitId, Level = Level})
end
---@param obj LiquidCoolingConfig.SetManualLevelReq
function TSetManualLevelReq:init_from_obj(obj)
    self.UnitId = obj.UnitId
    self.Level = obj.Level
end

function TSetManualLevelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetManualLevelReq.group)
end

TSetManualLevelReq.from_obj = TSetManualLevelReq_from_obj

TSetManualLevelReq.proto_property = {'UnitId', 'Level'}

TSetManualLevelReq.default = {0, 0}

TSetManualLevelReq.struct = {
    {name = 'UnitId', is_array = false, struct = nil}, {name = 'Level', is_array = false, struct = nil}
}

function TSetManualLevelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UnitId', self.UnitId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Level', self.Level, 'uint8', false, errs, need_convert)

    TSetManualLevelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetManualLevelReq.proto_property, errs, need_convert)
    return self
end

function TSetManualLevelReq:unpack(_)
    return self.UnitId, self.Level
end

LiquidCoolingConfig.SetManualLevelReq = TSetManualLevelReq

LiquidCoolingConfig.interface = mdb.register_interface('bmc.kepler.Systems.LiquidCoolingConfig', {
    CtrlMode = {'s', {'EMIT_CHANGE'}, true, 'Auto', false},
    TimeOut = {'u', {'VOLATILE'}, true, 30, false},
    ManualLevel = {'y', {'EMIT_CHANGE'}, true, 25, false},
    LevelPercentRange = {'ay', {'CONST'}, true, nil, false},
    ActiveAlgorithm = {'s', {}, true, 'N/A', false}
}, {
    SetManualLevel = {'a{ss}yy', '', TSetManualLevelReq, TSetManualLevelRsp},
    SetCtrlMode = {'a{ss}su', '', TSetCtrlModeReq, TSetCtrlModeRsp}
}, {})

return LiquidCoolingConfig
