-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local CoolingPolicy = {}

---@class CoolingPolicy.SpeedRangeHigh
---@field SpeedRangeHigh integer[]
local TSpeedRangeHigh = {}
TSpeedRangeHigh.__index = TSpeedRangeHigh
TSpeedRangeHigh.group = {}

local function TSpeedRangeHigh_from_obj(obj)
    return setmetatable(obj, TSpeedRangeHigh)
end

function TSpeedRangeHigh.new(SpeedRangeHigh)
    return TSpeedRangeHigh_from_obj({SpeedRangeHigh = SpeedRangeHigh})
end
---@param obj CoolingPolicy.SpeedRangeHigh
function TSpeedRangeHigh:init_from_obj(obj)
    self.SpeedRangeHigh = obj.SpeedRangeHigh
end

function TSpeedRangeHigh:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSpeedRangeHigh.group)
end

TSpeedRangeHigh.from_obj = TSpeedRangeHigh_from_obj

TSpeedRangeHigh.proto_property = {'SpeedRangeHigh'}

TSpeedRangeHigh.default = {{}}

TSpeedRangeHigh.struct = {{name = 'SpeedRangeHigh', is_array = true, struct = nil}}

function TSpeedRangeHigh:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SpeedRangeHigh', self.SpeedRangeHigh, 'int16', true, errs, need_convert)

    TSpeedRangeHigh:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSpeedRangeHigh.proto_property, errs, need_convert)
    return self
end

function TSpeedRangeHigh:unpack(_)
    return self.SpeedRangeHigh
end

CoolingPolicy.SpeedRangeHigh = TSpeedRangeHigh

---@class CoolingPolicy.SpeedRangeLow
---@field SpeedRangeLow integer[]
local TSpeedRangeLow = {}
TSpeedRangeLow.__index = TSpeedRangeLow
TSpeedRangeLow.group = {}

local function TSpeedRangeLow_from_obj(obj)
    return setmetatable(obj, TSpeedRangeLow)
end

function TSpeedRangeLow.new(SpeedRangeLow)
    return TSpeedRangeLow_from_obj({SpeedRangeLow = SpeedRangeLow})
end
---@param obj CoolingPolicy.SpeedRangeLow
function TSpeedRangeLow:init_from_obj(obj)
    self.SpeedRangeLow = obj.SpeedRangeLow
end

function TSpeedRangeLow:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSpeedRangeLow.group)
end

TSpeedRangeLow.from_obj = TSpeedRangeLow_from_obj

TSpeedRangeLow.proto_property = {'SpeedRangeLow'}

TSpeedRangeLow.default = {{}}

TSpeedRangeLow.struct = {{name = 'SpeedRangeLow', is_array = true, struct = nil}}

function TSpeedRangeLow:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SpeedRangeLow', self.SpeedRangeLow, 'int16', true, errs, need_convert)

    TSpeedRangeLow:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSpeedRangeLow.proto_property, errs, need_convert)
    return self
end

function TSpeedRangeLow:unpack(_)
    return self.SpeedRangeLow
end

CoolingPolicy.SpeedRangeLow = TSpeedRangeLow

---@class CoolingPolicy.TemperatureRangeHigh
---@field TemperatureRangeHigh integer[]
local TTemperatureRangeHigh = {}
TTemperatureRangeHigh.__index = TTemperatureRangeHigh
TTemperatureRangeHigh.group = {}

local function TTemperatureRangeHigh_from_obj(obj)
    return setmetatable(obj, TTemperatureRangeHigh)
end

function TTemperatureRangeHigh.new(TemperatureRangeHigh)
    return TTemperatureRangeHigh_from_obj({TemperatureRangeHigh = TemperatureRangeHigh})
end
---@param obj CoolingPolicy.TemperatureRangeHigh
function TTemperatureRangeHigh:init_from_obj(obj)
    self.TemperatureRangeHigh = obj.TemperatureRangeHigh
end

function TTemperatureRangeHigh:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureRangeHigh.group)
end

TTemperatureRangeHigh.from_obj = TTemperatureRangeHigh_from_obj

TTemperatureRangeHigh.proto_property = {'TemperatureRangeHigh'}

TTemperatureRangeHigh.default = {{}}

TTemperatureRangeHigh.struct = {{name = 'TemperatureRangeHigh', is_array = true, struct = nil}}

function TTemperatureRangeHigh:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'TemperatureRangeHigh', self.TemperatureRangeHigh, 'int16', true, errs,
        need_convert)

    TTemperatureRangeHigh:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureRangeHigh.proto_property, errs, need_convert)
    return self
end

function TTemperatureRangeHigh:unpack(_)
    return self.TemperatureRangeHigh
end

CoolingPolicy.TemperatureRangeHigh = TTemperatureRangeHigh

---@class CoolingPolicy.TemperatureRangeLow
---@field TemperatureRangeLow integer[]
local TTemperatureRangeLow = {}
TTemperatureRangeLow.__index = TTemperatureRangeLow
TTemperatureRangeLow.group = {}

local function TTemperatureRangeLow_from_obj(obj)
    return setmetatable(obj, TTemperatureRangeLow)
end

function TTemperatureRangeLow.new(TemperatureRangeLow)
    return TTemperatureRangeLow_from_obj({TemperatureRangeLow = TemperatureRangeLow})
end
---@param obj CoolingPolicy.TemperatureRangeLow
function TTemperatureRangeLow:init_from_obj(obj)
    self.TemperatureRangeLow = obj.TemperatureRangeLow
end

function TTemperatureRangeLow:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureRangeLow.group)
end

TTemperatureRangeLow.from_obj = TTemperatureRangeLow_from_obj

TTemperatureRangeLow.proto_property = {'TemperatureRangeLow'}

TTemperatureRangeLow.default = {{}}

TTemperatureRangeLow.struct = {{name = 'TemperatureRangeLow', is_array = true, struct = nil}}

function TTemperatureRangeLow:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'TemperatureRangeLow', self.TemperatureRangeLow, 'int16', true, errs, need_convert)

    TTemperatureRangeLow:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureRangeLow.proto_property, errs, need_convert)
    return self
end

function TTemperatureRangeLow:unpack(_)
    return self.TemperatureRangeLow
end

CoolingPolicy.TemperatureRangeLow = TTemperatureRangeLow

---@class CoolingPolicy.Hysteresis
---@field Hysteresis integer
local THysteresis = {}
THysteresis.__index = THysteresis
THysteresis.group = {}

local function THysteresis_from_obj(obj)
    return setmetatable(obj, THysteresis)
end

function THysteresis.new(Hysteresis)
    return THysteresis_from_obj({Hysteresis = Hysteresis or 0})
end
---@param obj CoolingPolicy.Hysteresis
function THysteresis:init_from_obj(obj)
    self.Hysteresis = obj.Hysteresis or 0
end

function THysteresis:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THysteresis.group)
end

THysteresis.from_obj = THysteresis_from_obj

THysteresis.proto_property = {'Hysteresis'}

THysteresis.default = {0}

THysteresis.struct = {{name = 'Hysteresis', is_array = false, struct = nil}}

function THysteresis:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Hysteresis', self.Hysteresis, 'uint8', true, errs, need_convert)

    THysteresis:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THysteresis.proto_property, errs, need_convert)
    return self
end

function THysteresis:unpack(_)
    return self.Hysteresis
end

CoolingPolicy.Hysteresis = THysteresis

---@class CoolingPolicy.FanSpeedRangePercents
---@field FanSpeedRangePercents integer[]
local TFanSpeedRangePercents = {}
TFanSpeedRangePercents.__index = TFanSpeedRangePercents
TFanSpeedRangePercents.group = {}

local function TFanSpeedRangePercents_from_obj(obj)
    return setmetatable(obj, TFanSpeedRangePercents)
end

function TFanSpeedRangePercents.new(FanSpeedRangePercents)
    return TFanSpeedRangePercents_from_obj({FanSpeedRangePercents = FanSpeedRangePercents})
end
---@param obj CoolingPolicy.FanSpeedRangePercents
function TFanSpeedRangePercents:init_from_obj(obj)
    self.FanSpeedRangePercents = obj.FanSpeedRangePercents
end

function TFanSpeedRangePercents:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanSpeedRangePercents.group)
end

TFanSpeedRangePercents.from_obj = TFanSpeedRangePercents_from_obj

TFanSpeedRangePercents.proto_property = {'FanSpeedRangePercents'}

TFanSpeedRangePercents.default = {{}}

TFanSpeedRangePercents.struct = {{name = 'FanSpeedRangePercents', is_array = true, struct = nil}}

function TFanSpeedRangePercents:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'FanSpeedRangePercents', self.FanSpeedRangePercents, 'uint8', true, errs,
        need_convert)

    TFanSpeedRangePercents:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanSpeedRangePercents.proto_property, errs, need_convert)
    return self
end

function TFanSpeedRangePercents:unpack(_)
    return self.FanSpeedRangePercents
end

CoolingPolicy.FanSpeedRangePercents = TFanSpeedRangePercents

---@class CoolingPolicy.CustomSupported
---@field CustomSupported boolean
local TCustomSupported = {}
TCustomSupported.__index = TCustomSupported
TCustomSupported.group = {}

local function TCustomSupported_from_obj(obj)
    return setmetatable(obj, TCustomSupported)
end

function TCustomSupported.new(CustomSupported)
    return TCustomSupported_from_obj({CustomSupported = CustomSupported})
end
---@param obj CoolingPolicy.CustomSupported
function TCustomSupported:init_from_obj(obj)
    self.CustomSupported = obj.CustomSupported
end

function TCustomSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomSupported.group)
end

TCustomSupported.from_obj = TCustomSupported_from_obj

TCustomSupported.proto_property = {'CustomSupported'}

TCustomSupported.default = {false}

TCustomSupported.struct = {{name = 'CustomSupported', is_array = false, struct = nil}}

function TCustomSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CustomSupported', self.CustomSupported, 'bool', true, errs, need_convert)

    TCustomSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomSupported.proto_property, errs, need_convert)
    return self
end

function TCustomSupported:unpack(_)
    return self.CustomSupported
end

CoolingPolicy.CustomSupported = TCustomSupported

---@class CoolingPolicy.ActualCondVal
---@field ActualCondVal string
local TActualCondVal = {}
TActualCondVal.__index = TActualCondVal
TActualCondVal.group = {}

local function TActualCondVal_from_obj(obj)
    return setmetatable(obj, TActualCondVal)
end

function TActualCondVal.new(ActualCondVal)
    return TActualCondVal_from_obj({ActualCondVal = ActualCondVal})
end
---@param obj CoolingPolicy.ActualCondVal
function TActualCondVal:init_from_obj(obj)
    self.ActualCondVal = obj.ActualCondVal
end

function TActualCondVal:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActualCondVal.group)
end

TActualCondVal.from_obj = TActualCondVal_from_obj

TActualCondVal.proto_property = {'ActualCondVal'}

TActualCondVal.default = {''}

TActualCondVal.struct = {{name = 'ActualCondVal', is_array = false, struct = nil}}

function TActualCondVal:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActualCondVal', self.ActualCondVal, 'string', true, errs, need_convert)

    TActualCondVal:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActualCondVal.proto_property, errs, need_convert)
    return self
end

function TActualCondVal:unpack(_)
    return self.ActualCondVal
end

CoolingPolicy.ActualCondVal = TActualCondVal

---@class CoolingPolicy.ExpCondVal
---@field ExpCondVal string
local TExpCondVal = {}
TExpCondVal.__index = TExpCondVal
TExpCondVal.group = {}

local function TExpCondVal_from_obj(obj)
    return setmetatable(obj, TExpCondVal)
end

function TExpCondVal.new(ExpCondVal)
    return TExpCondVal_from_obj({ExpCondVal = ExpCondVal})
end
---@param obj CoolingPolicy.ExpCondVal
function TExpCondVal:init_from_obj(obj)
    self.ExpCondVal = obj.ExpCondVal
end

function TExpCondVal:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExpCondVal.group)
end

TExpCondVal.from_obj = TExpCondVal_from_obj

TExpCondVal.proto_property = {'ExpCondVal'}

TExpCondVal.default = {''}

TExpCondVal.struct = {{name = 'ExpCondVal', is_array = false, struct = nil}}

function TExpCondVal:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ExpCondVal', self.ExpCondVal, 'string', true, errs, need_convert)

    TExpCondVal:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExpCondVal.proto_property, errs, need_convert)
    return self
end

function TExpCondVal:unpack(_)
    return self.ExpCondVal
end

CoolingPolicy.ExpCondVal = TExpCondVal

---@class CoolingPolicy.IsValid
---@field IsValid integer
local TIsValid = {}
TIsValid.__index = TIsValid
TIsValid.group = {}

local function TIsValid_from_obj(obj)
    return setmetatable(obj, TIsValid)
end

function TIsValid.new(IsValid)
    return TIsValid_from_obj({IsValid = IsValid or 1})
end
---@param obj CoolingPolicy.IsValid
function TIsValid:init_from_obj(obj)
    self.IsValid = obj.IsValid or 1
end

function TIsValid:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsValid.group)
end

TIsValid.from_obj = TIsValid_from_obj

TIsValid.proto_property = {'IsValid'}

TIsValid.default = {0}

TIsValid.struct = {{name = 'IsValid', is_array = false, struct = nil}}

function TIsValid:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsValid', self.IsValid, 'uint8', true, errs, need_convert)

    TIsValid:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsValid.proto_property, errs, need_convert)
    return self
end

function TIsValid:unpack(_)
    return self.IsValid
end

CoolingPolicy.IsValid = TIsValid

---@class CoolingPolicy.PolicyType
---@field PolicyType integer
local TPolicyType = {}
TPolicyType.__index = TPolicyType
TPolicyType.group = {}

local function TPolicyType_from_obj(obj)
    return setmetatable(obj, TPolicyType)
end

function TPolicyType.new(PolicyType)
    return TPolicyType_from_obj({PolicyType = PolicyType or 4294967295})
end
---@param obj CoolingPolicy.PolicyType
function TPolicyType:init_from_obj(obj)
    self.PolicyType = obj.PolicyType or 4294967295
end

function TPolicyType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPolicyType.group)
end

TPolicyType.from_obj = TPolicyType_from_obj

TPolicyType.proto_property = {'PolicyType'}

TPolicyType.default = {0}

TPolicyType.struct = {{name = 'PolicyType', is_array = false, struct = nil}}

function TPolicyType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PolicyType', self.PolicyType, 'uint32', true, errs, need_convert)

    TPolicyType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPolicyType.proto_property, errs, need_convert)
    return self
end

function TPolicyType:unpack(_)
    return self.PolicyType
end

CoolingPolicy.PolicyType = TPolicyType

---@class CoolingPolicy.PolicyIdx
---@field PolicyIdx integer
local TPolicyIdx = {}
TPolicyIdx.__index = TPolicyIdx
TPolicyIdx.group = {}

local function TPolicyIdx_from_obj(obj)
    return setmetatable(obj, TPolicyIdx)
end

function TPolicyIdx.new(PolicyIdx)
    return TPolicyIdx_from_obj({PolicyIdx = PolicyIdx})
end
---@param obj CoolingPolicy.PolicyIdx
function TPolicyIdx:init_from_obj(obj)
    self.PolicyIdx = obj.PolicyIdx
end

function TPolicyIdx:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPolicyIdx.group)
end

TPolicyIdx.from_obj = TPolicyIdx_from_obj

TPolicyIdx.proto_property = {'PolicyIdx'}

TPolicyIdx.default = {0}

TPolicyIdx.struct = {{name = 'PolicyIdx', is_array = false, struct = nil}}

function TPolicyIdx:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'PolicyIdx', self.PolicyIdx, 'uint8', true, errs, need_convert)

    TPolicyIdx:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPolicyIdx.proto_property, errs, need_convert)
    return self
end

function TPolicyIdx:unpack(_)
    return self.PolicyIdx
end

CoolingPolicy.PolicyIdx = TPolicyIdx

---@class CoolingPolicy.SetHysteresisRsp
local TSetHysteresisRsp = {}
TSetHysteresisRsp.__index = TSetHysteresisRsp
TSetHysteresisRsp.group = {}

local function TSetHysteresisRsp_from_obj(obj)
    return setmetatable(obj, TSetHysteresisRsp)
end

function TSetHysteresisRsp.new()
    return TSetHysteresisRsp_from_obj({})
end
---@param obj CoolingPolicy.SetHysteresisRsp
function TSetHysteresisRsp:init_from_obj(obj)

end

function TSetHysteresisRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetHysteresisRsp.group)
end

TSetHysteresisRsp.from_obj = TSetHysteresisRsp_from_obj

TSetHysteresisRsp.proto_property = {}

TSetHysteresisRsp.default = {}

TSetHysteresisRsp.struct = {}

function TSetHysteresisRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetHysteresisRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetHysteresisRsp.proto_property, errs, need_convert)
    return self
end

function TSetHysteresisRsp:unpack(_)
end

CoolingPolicy.SetHysteresisRsp = TSetHysteresisRsp

---@class CoolingPolicy.SetHysteresisReq
---@field Hysteresis integer
local TSetHysteresisReq = {}
TSetHysteresisReq.__index = TSetHysteresisReq
TSetHysteresisReq.group = {}

local function TSetHysteresisReq_from_obj(obj)
    return setmetatable(obj, TSetHysteresisReq)
end

function TSetHysteresisReq.new(Hysteresis)
    return TSetHysteresisReq_from_obj({Hysteresis = Hysteresis})
end
---@param obj CoolingPolicy.SetHysteresisReq
function TSetHysteresisReq:init_from_obj(obj)
    self.Hysteresis = obj.Hysteresis
end

function TSetHysteresisReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetHysteresisReq.group)
end

TSetHysteresisReq.from_obj = TSetHysteresisReq_from_obj

TSetHysteresisReq.proto_property = {'Hysteresis'}

TSetHysteresisReq.default = {0}

TSetHysteresisReq.struct = {{name = 'Hysteresis', is_array = false, struct = nil}}

function TSetHysteresisReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Hysteresis', self.Hysteresis, 'uint8', false, errs, need_convert)

    TSetHysteresisReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetHysteresisReq.proto_property, errs, need_convert)
    return self
end

function TSetHysteresisReq:unpack(_)
    return self.Hysteresis
end

CoolingPolicy.SetHysteresisReq = TSetHysteresisReq

---@class CoolingPolicy.SetCustomCoolingPolicyRsp
local TSetCustomCoolingPolicyRsp = {}
TSetCustomCoolingPolicyRsp.__index = TSetCustomCoolingPolicyRsp
TSetCustomCoolingPolicyRsp.group = {}

local function TSetCustomCoolingPolicyRsp_from_obj(obj)
    return setmetatable(obj, TSetCustomCoolingPolicyRsp)
end

function TSetCustomCoolingPolicyRsp.new()
    return TSetCustomCoolingPolicyRsp_from_obj({})
end
---@param obj CoolingPolicy.SetCustomCoolingPolicyRsp
function TSetCustomCoolingPolicyRsp:init_from_obj(obj)

end

function TSetCustomCoolingPolicyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCustomCoolingPolicyRsp.group)
end

TSetCustomCoolingPolicyRsp.from_obj = TSetCustomCoolingPolicyRsp_from_obj

TSetCustomCoolingPolicyRsp.proto_property = {}

TSetCustomCoolingPolicyRsp.default = {}

TSetCustomCoolingPolicyRsp.struct = {}

function TSetCustomCoolingPolicyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetCustomCoolingPolicyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCustomCoolingPolicyRsp.proto_property, errs, need_convert)
    return self
end

function TSetCustomCoolingPolicyRsp:unpack(_)
end

CoolingPolicy.SetCustomCoolingPolicyRsp = TSetCustomCoolingPolicyRsp

---@class CoolingPolicy.SetCustomCoolingPolicyReq
---@field TemperatureArray integer[]
---@field FanSpeedArray integer[]
local TSetCustomCoolingPolicyReq = {}
TSetCustomCoolingPolicyReq.__index = TSetCustomCoolingPolicyReq
TSetCustomCoolingPolicyReq.group = {}

local function TSetCustomCoolingPolicyReq_from_obj(obj)
    return setmetatable(obj, TSetCustomCoolingPolicyReq)
end

function TSetCustomCoolingPolicyReq.new(TemperatureArray, FanSpeedArray)
    return TSetCustomCoolingPolicyReq_from_obj({TemperatureArray = TemperatureArray, FanSpeedArray = FanSpeedArray})
end
---@param obj CoolingPolicy.SetCustomCoolingPolicyReq
function TSetCustomCoolingPolicyReq:init_from_obj(obj)
    self.TemperatureArray = obj.TemperatureArray
    self.FanSpeedArray = obj.FanSpeedArray
end

function TSetCustomCoolingPolicyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCustomCoolingPolicyReq.group)
end

TSetCustomCoolingPolicyReq.from_obj = TSetCustomCoolingPolicyReq_from_obj

TSetCustomCoolingPolicyReq.proto_property = {'TemperatureArray', 'FanSpeedArray'}

TSetCustomCoolingPolicyReq.default = {{}, {}}

TSetCustomCoolingPolicyReq.struct = {
    {name = 'TemperatureArray', is_array = true, struct = nil}, {name = 'FanSpeedArray', is_array = true, struct = nil}
}

function TSetCustomCoolingPolicyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'TemperatureArray', self.TemperatureArray, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'FanSpeedArray', self.FanSpeedArray, 'uint8', false, errs, need_convert)

    TSetCustomCoolingPolicyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCustomCoolingPolicyReq.proto_property, errs, need_convert)
    return self
end

function TSetCustomCoolingPolicyReq:unpack(_)
    return self.TemperatureArray, self.FanSpeedArray
end

CoolingPolicy.SetCustomCoolingPolicyReq = TSetCustomCoolingPolicyReq

CoolingPolicy.interface = mdb.register_interface('bmc.kepler.Systems.CoolingPolicy', {
    PolicyIdx = {'y', {'CONST'}, true, nil, false},
    PolicyType = {'u', {'CONST'}, true, 4294967295, false},
    IsValid = {'y', {}, true, 1, false},
    ExpCondVal = {'s', {}, true, nil, false},
    ActualCondVal = {'s', {}, true, nil, false},
    CustomSupported = {'b', {'CONST'}, true, nil, false},
    FanSpeedRangePercents = {'ay', {'CONST'}, true, nil, false},
    Hysteresis = {'y', {'CONST'}, true, 0, false},
    TemperatureRangeLow = {'an', {}, true, nil, false},
    TemperatureRangeHigh = {'an', {}, true, nil, false},
    SpeedRangeLow = {'an', {}, true, nil, false},
    SpeedRangeHigh = {'an', {}, true, nil, false}
}, {
    SetCustomCoolingPolicy = {'a{ss}ayay', '', TSetCustomCoolingPolicyReq, TSetCustomCoolingPolicyRsp},
    SetHysteresis = {'a{ss}y', '', TSetHysteresisReq, TSetHysteresisRsp}
}, {})

return CoolingPolicy
