--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local bs = require 'mc.bitstring'
local enums = require 'ipmi.enums'
local ipmi = require 'ipmi'
local types = require 'ipmi.types'
local privilege = require 'mc.privilege'
local msg = require 'thermal_mgmt.ipmi.ipmi_message'

local CT = enums.ChannelType

local ThermalMgmtIpmiCmds = {}

ThermalMgmtIpmiCmds.GetFanSpeed = {
    name = 'GetFanSpeed',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,31,04,01]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x31:1/unit:8, 0x04:1/un]=] ..
        [=[it:8, 0x01:1/unit:8, DeviceNumber:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reading:4/unit:8, Unit:1/unit:8>>]=],
    req = msg.GetFanSpeedReq,
    rsp = msg.GetFanSpeedRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ThermalMgmtIpmiCmds.GetValveOpeningDegree = {
    name = 'GetValveOpeningDegree',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,7D,*,01]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x7D:1/unit:8, Index:1/u]=] .. [=[nit:8, 0x01:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Data:2/unit:8>>]=],
    req = msg.GetValveOpeningDegreeReq,
    rsp = msg.GetValveOpeningDegreeRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ThermalMgmtIpmiCmds.GetValveStandardOpeningDegree = {
    name = 'GetValveStandardOpeningDegree',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,7D,*,02]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x7D:1/unit:8, Index:1/u]=] .. [=[nit:8, 0x02:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Data:2/unit:8>>]=],
    req = msg.GetValveStandardOpeningDegreeReq,
    rsp = msg.GetValveStandardOpeningDegreeRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ThermalMgmtIpmiCmds.SetValveOpeningDegree = {
    name = 'SetValveOpeningDegree',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,7E,*,01]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x7E:1/unit:8, Index:1/u]=] ..
        [=[nit:8, 0x01:1/unit:8, Length:1/unit:8, Data:2/unit]=] .. [=[:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetValveOpeningDegreeReq,
    rsp = msg.SetValveOpeningDegreeRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

ThermalMgmtIpmiCmds.GetTotalFanPower = {
    name = 'GetTotalFanPower',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,31,08,03,FF]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x31:1/unit:8, 0x08:1/un]=] .. [=[it:8, 0x03:1/unit:8, 0xFF:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ FanPower:4/unit:8, Unit:1/unit:8>>]=],
    req = msg.GetTotalFanPowerReq,
    rsp = msg.GetTotalFanPowerRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ThermalMgmtIpmiCmds.SetFanCtlMode = {
    name = 'SetFanCtlMode',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x91,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,01]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x01:1/unit:8, Mode:1/un]=] .. [=[it:8, AddInfo/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetFanCtlModeReq,
    rsp = msg.SetFanCtlModeRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ThermalMgmtIpmiCmds.GetFanCtlMode = {
    name = 'GetFanCtlMode',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x91,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,02]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x02:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Mode:1/unit:8, Timeout/string>>]=],
    req = msg.GetFanCtlModeReq,
    rsp = msg.GetFanCtlModeRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ThermalMgmtIpmiCmds.SetFanLevel = {
    name = 'SetFanLevel',
    prio = types.Priority.Default,
    netfn = 0x2c,
    cmd = 0x15,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<PicmgIdentifier:1/unit:8, FruId:1/unit:8, FanLev]=] .. [=[el:1/unit:8, LocalCtllEnable/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, PicmgIdentifier:1/unit:]=] .. [=[8>>]=],
    req = msg.SetFanLevelReq,
    rsp = msg.SetFanLevelRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

ThermalMgmtIpmiCmds.GetFanLevel = {
    name = 'GetFanLevel',
    prio = types.Priority.Default,
    netfn = 0x2c,
    cmd = 0x16,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<PicmgIdentifier:1/unit:8, FruId:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, PicmgIdentifier:1/unit:]=] .. [=[8, LocalCtlFanLevel:1/unit:8>>]=],
    req = msg.GetFanLevelReq,
    rsp = msg.GetFanLevelRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

ThermalMgmtIpmiCmds.SetCoolingMode = {
    name = 'SetCoolingMode',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,13]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x13:1/unit:8, PolicyOpt]=] .. [=[ion:1/unit:8, PolicyValue:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetCoolingModeReq,
    rsp = msg.SetCoolingModeRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ThermalMgmtIpmiCmds.GetCoolingMode = {
    name = 'GetCoolingMode',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,14]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x14:1/unit:8, PolicyOpt]=] .. [=[ion/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ PolicyOption:1/unit:8, PolicyValue:1/unit:8>>]=],
    req = msg.GetCoolingModeReq,
    rsp = msg.GetCoolingModeRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ThermalMgmtIpmiCmds.GetFanSpdProps = {
    name = 'GetFanSpdProps',
    prio = types.Priority.Default,
    netfn = 0x2c,
    cmd = 0x14,
    role = types.Role.Operator,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<SystemId:1/unit:8, FruId:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, PicmgIdentifier:1/unit:]=] ..
        [=[8, MinimalSpd:1/unit:8, MaximumSpd:1/unit:8, Defau]=] .. [=[ltSpd:1/unit:8, DefaultData:1/unit:8>>]=],
    req = msg.GetFanSpdPropsReq,
    rsp = msg.GetFanSpdPropsRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

ThermalMgmtIpmiCmds.GetInletPolicy = {
    name = 'GetInletPolicy',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,46]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x46:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EnvArrLen:1/unit:8, EnvSpdArr/string>>]=],
    req = msg.GetInletPolicyReq,
    rsp = msg.GetInletPolicyRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ThermalMgmtIpmiCmds.SetInletPolicy = {
    name = 'SetInletPolicy',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,45]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x45:1/unit:8, EnvArrLen]=] .. [=[:1/unit:8, EnvSpdArr/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetInletPolicyReq,
    rsp = msg.SetInletPolicyRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ThermalMgmtIpmiCmds.SetInitCoolingUnitLevel = {
    name = 'SetInitCoolingUnitLevel',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,5a,1f,00]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x5a:1/unit:8, 0x001f:2/]=] ..
        [=[unit:8, ParamLen:2/unit:8, Level:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetInitCoolingUnitLevelReq,
    rsp = msg.SetInitCoolingUnitLevelRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ThermalMgmtIpmiCmds.GetInitCoolingUnitLevel = {
    name = 'GetInitCoolingUnitLevel',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,5b,1f,00]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x5b:1/unit:8, 0x001f:2/]=] .. [=[unit:8, ParamLen:2/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Level:1/unit:8>>]=],
    req = msg.GetInitCoolingUnitLevelReq,
    rsp = msg.GetInitCoolingUnitLevelRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ThermalMgmtIpmiCmds.SetCoolingDeviceMode = {
    name = 'SetCoolingDeviceMode',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x91,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,23]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x23:1/unit:8, DeviceTyp]=] ..
        [=[e:1/unit:8, Mode:1/unit:8, Timeout/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetCoolingDeviceModeReq,
    rsp = msg.SetCoolingDeviceModeRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ThermalMgmtIpmiCmds.GetCoolingDeviceMode = {
    name = 'GetCoolingDeviceMode',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x91,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,24]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x24:1/unit:8, DeviceTyp]=] .. [=[e:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Mode:1/unit:8, Timeout/string>>]=],
    req = msg.GetCoolingDeviceModeReq,
    rsp = msg.GetCoolingDeviceModeRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ThermalMgmtIpmiCmds.SetCoolingDeviceLevel = {
    name = 'SetCoolingDeviceLevel',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x91,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,25]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x25:1/unit:8, DeviceTyp]=] ..
        [=[e:1/unit:8, DeviceId:1/unit:8, Level:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetCoolingDeviceLevelReq,
    rsp = msg.SetCoolingDeviceLevelRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ThermalMgmtIpmiCmds.GetCoolingDeviceLevel = {
    name = 'GetCoolingDeviceLevel',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x91,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,26]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x26:1/unit:8, DeviceTyp]=] ..
        [=[e:1/unit:8, DeviceId:1/unit:8, Mode:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ DeviceNum:1/unit:8, Level/string>>]=],
    req = msg.GetCoolingDeviceLevelReq,
    rsp = msg.GetCoolingDeviceLevelRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

return ThermalMgmtIpmiCmds
