--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetValveOpeningDegree = {}

---@class ThermalMgmtIpmiCmds.SetValveOpeningDegreeReq
---@field ManufactureId integer
---@field Index integer
---@field Length integer
---@field Data integer
local TSetValveOpeningDegreeReq = {}
TSetValveOpeningDegreeReq.__index = TSetValveOpeningDegreeReq
TSetValveOpeningDegreeReq.group = {}

local function TSetValveOpeningDegreeReq_from_obj(obj)
    return setmetatable(obj, TSetValveOpeningDegreeReq)
end

function TSetValveOpeningDegreeReq.new(ManufactureId, Index, Length, Data)
    return TSetValveOpeningDegreeReq_from_obj({
        ManufactureId = ManufactureId,
        Index = Index,
        Length = Length,
        Data = Data
    })
end
---@param obj ThermalMgmtIpmiCmds.SetValveOpeningDegreeReq
function TSetValveOpeningDegreeReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Index = obj.Index
    self.Length = obj.Length
    self.Data = obj.Data
end

function TSetValveOpeningDegreeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetValveOpeningDegreeReq.group)
end

TSetValveOpeningDegreeReq.from_obj = TSetValveOpeningDegreeReq_from_obj

TSetValveOpeningDegreeReq.proto_property = {'ManufactureId', 'Index', 'Length', 'Data'}

TSetValveOpeningDegreeReq.default = {0, 0, 0, 0}

TSetValveOpeningDegreeReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Index', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetValveOpeningDegreeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Index', self.Index, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'uint16', false, errs, need_convert)

    TSetValveOpeningDegreeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetValveOpeningDegreeReq.proto_property, errs, need_convert)
    return self
end

function TSetValveOpeningDegreeReq:unpack(_)
    return self.ManufactureId, self.Index, self.Length, self.Data
end

SetValveOpeningDegree.SetValveOpeningDegreeReq = TSetValveOpeningDegreeReq

---@class ThermalMgmtIpmiCmds.SetValveOpeningDegreeRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetValveOpeningDegreeRsp = {}
TSetValveOpeningDegreeRsp.__index = TSetValveOpeningDegreeRsp
TSetValveOpeningDegreeRsp.group = {}

local function TSetValveOpeningDegreeRsp_from_obj(obj)
    return setmetatable(obj, TSetValveOpeningDegreeRsp)
end

function TSetValveOpeningDegreeRsp.new(CompletionCode, ManufactureId)
    return TSetValveOpeningDegreeRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj ThermalMgmtIpmiCmds.SetValveOpeningDegreeRsp
function TSetValveOpeningDegreeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetValveOpeningDegreeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetValveOpeningDegreeRsp.group)
end

TSetValveOpeningDegreeRsp.from_obj = TSetValveOpeningDegreeRsp_from_obj

TSetValveOpeningDegreeRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetValveOpeningDegreeRsp.default = {0, 0}

TSetValveOpeningDegreeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetValveOpeningDegreeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetValveOpeningDegreeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetValveOpeningDegreeRsp.proto_property, errs, need_convert)
    return self
end

function TSetValveOpeningDegreeRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetValveOpeningDegree.SetValveOpeningDegreeRsp = TSetValveOpeningDegreeRsp

return SetValveOpeningDegree
