--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetInletPolicy = {}

---@class ThermalMgmtIpmiCmds.SetInletPolicyReq
---@field ManufactureId integer
---@field EnvArrLen integer
---@field EnvSpdArr string
local TSetInletPolicyReq = {}
TSetInletPolicyReq.__index = TSetInletPolicyReq
TSetInletPolicyReq.group = {}

local function TSetInletPolicyReq_from_obj(obj)
    return setmetatable(obj, TSetInletPolicyReq)
end

function TSetInletPolicyReq.new(ManufactureId, EnvArrLen, EnvSpdArr)
    return TSetInletPolicyReq_from_obj({ManufactureId = ManufactureId, EnvArrLen = EnvArrLen, EnvSpdArr = EnvSpdArr})
end
---@param obj ThermalMgmtIpmiCmds.SetInletPolicyReq
function TSetInletPolicyReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.EnvArrLen = obj.EnvArrLen
    self.EnvSpdArr = obj.EnvSpdArr
end

function TSetInletPolicyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetInletPolicyReq.group)
end

TSetInletPolicyReq.from_obj = TSetInletPolicyReq_from_obj

TSetInletPolicyReq.proto_property = {'ManufactureId', 'EnvArrLen', 'EnvSpdArr'}

TSetInletPolicyReq.default = {0, 0, ''}

TSetInletPolicyReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'EnvArrLen', is_array = false, struct = nil},
    {name = 'EnvSpdArr', is_array = false, struct = nil}
}

function TSetInletPolicyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EnvArrLen', self.EnvArrLen, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'EnvSpdArr', self.EnvSpdArr, 'string', false, errs, need_convert)

    TSetInletPolicyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetInletPolicyReq.proto_property, errs, need_convert)
    return self
end

function TSetInletPolicyReq:unpack(_)
    return self.ManufactureId, self.EnvArrLen, self.EnvSpdArr
end

SetInletPolicy.SetInletPolicyReq = TSetInletPolicyReq

---@class ThermalMgmtIpmiCmds.SetInletPolicyRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetInletPolicyRsp = {}
TSetInletPolicyRsp.__index = TSetInletPolicyRsp
TSetInletPolicyRsp.group = {}

local function TSetInletPolicyRsp_from_obj(obj)
    return setmetatable(obj, TSetInletPolicyRsp)
end

function TSetInletPolicyRsp.new(CompletionCode, ManufactureId)
    return TSetInletPolicyRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj ThermalMgmtIpmiCmds.SetInletPolicyRsp
function TSetInletPolicyRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetInletPolicyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetInletPolicyRsp.group)
end

TSetInletPolicyRsp.from_obj = TSetInletPolicyRsp_from_obj

TSetInletPolicyRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetInletPolicyRsp.default = {0, 0}

TSetInletPolicyRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetInletPolicyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetInletPolicyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetInletPolicyRsp.proto_property, errs, need_convert)
    return self
end

function TSetInletPolicyRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetInletPolicy.SetInletPolicyRsp = TSetInletPolicyRsp

return SetInletPolicy
