--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetCoolingDeviceMode = {}

---@class ThermalMgmtIpmiCmds.SetCoolingDeviceModeReq
---@field ManufactureId integer
---@field DeviceType integer
---@field Mode integer
---@field Timeout string
local TSetCoolingDeviceModeReq = {}
TSetCoolingDeviceModeReq.__index = TSetCoolingDeviceModeReq
TSetCoolingDeviceModeReq.group = {}

local function TSetCoolingDeviceModeReq_from_obj(obj)
    return setmetatable(obj, TSetCoolingDeviceModeReq)
end

function TSetCoolingDeviceModeReq.new(ManufactureId, DeviceType, Mode, Timeout)
    return TSetCoolingDeviceModeReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceType = DeviceType,
        Mode = Mode,
        Timeout = Timeout
    })
end
---@param obj ThermalMgmtIpmiCmds.SetCoolingDeviceModeReq
function TSetCoolingDeviceModeReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceType = obj.DeviceType
    self.Mode = obj.Mode
    self.Timeout = obj.Timeout
end

function TSetCoolingDeviceModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCoolingDeviceModeReq.group)
end

TSetCoolingDeviceModeReq.from_obj = TSetCoolingDeviceModeReq_from_obj

TSetCoolingDeviceModeReq.proto_property = {'ManufactureId', 'DeviceType', 'Mode', 'Timeout'}

TSetCoolingDeviceModeReq.default = {0, 0, 0, ''}

TSetCoolingDeviceModeReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceType', is_array = false, struct = nil},
    {name = 'Mode', is_array = false, struct = nil}, {name = 'Timeout', is_array = false, struct = nil}
}

function TSetCoolingDeviceModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Mode', self.Mode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Timeout', self.Timeout, 'string', false, errs, need_convert)

    TSetCoolingDeviceModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCoolingDeviceModeReq.proto_property, errs, need_convert)
    return self
end

function TSetCoolingDeviceModeReq:unpack(_)
    return self.ManufactureId, self.DeviceType, self.Mode, self.Timeout
end

SetCoolingDeviceMode.SetCoolingDeviceModeReq = TSetCoolingDeviceModeReq

---@class ThermalMgmtIpmiCmds.SetCoolingDeviceModeRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetCoolingDeviceModeRsp = {}
TSetCoolingDeviceModeRsp.__index = TSetCoolingDeviceModeRsp
TSetCoolingDeviceModeRsp.group = {}

local function TSetCoolingDeviceModeRsp_from_obj(obj)
    return setmetatable(obj, TSetCoolingDeviceModeRsp)
end

function TSetCoolingDeviceModeRsp.new(CompletionCode, ManufactureId)
    return TSetCoolingDeviceModeRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj ThermalMgmtIpmiCmds.SetCoolingDeviceModeRsp
function TSetCoolingDeviceModeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetCoolingDeviceModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCoolingDeviceModeRsp.group)
end

TSetCoolingDeviceModeRsp.from_obj = TSetCoolingDeviceModeRsp_from_obj

TSetCoolingDeviceModeRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetCoolingDeviceModeRsp.default = {0, 0}

TSetCoolingDeviceModeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetCoolingDeviceModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetCoolingDeviceModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCoolingDeviceModeRsp.proto_property, errs, need_convert)
    return self
end

function TSetCoolingDeviceModeRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetCoolingDeviceMode.SetCoolingDeviceModeRsp = TSetCoolingDeviceModeRsp

return SetCoolingDeviceMode
