--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetCoolingDeviceLevel = {}

---@class ThermalMgmtIpmiCmds.SetCoolingDeviceLevelReq
---@field ManufactureId integer
---@field DeviceType integer
---@field DeviceId integer
---@field Level integer
local TSetCoolingDeviceLevelReq = {}
TSetCoolingDeviceLevelReq.__index = TSetCoolingDeviceLevelReq
TSetCoolingDeviceLevelReq.group = {}

local function TSetCoolingDeviceLevelReq_from_obj(obj)
    return setmetatable(obj, TSetCoolingDeviceLevelReq)
end

function TSetCoolingDeviceLevelReq.new(ManufactureId, DeviceType, DeviceId, Level)
    return TSetCoolingDeviceLevelReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceType = DeviceType,
        DeviceId = DeviceId,
        Level = Level
    })
end
---@param obj ThermalMgmtIpmiCmds.SetCoolingDeviceLevelReq
function TSetCoolingDeviceLevelReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceType = obj.DeviceType
    self.DeviceId = obj.DeviceId
    self.Level = obj.Level
end

function TSetCoolingDeviceLevelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCoolingDeviceLevelReq.group)
end

TSetCoolingDeviceLevelReq.from_obj = TSetCoolingDeviceLevelReq_from_obj

TSetCoolingDeviceLevelReq.proto_property = {'ManufactureId', 'DeviceType', 'DeviceId', 'Level'}

TSetCoolingDeviceLevelReq.default = {0, 0, 0, 0}

TSetCoolingDeviceLevelReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceType', is_array = false, struct = nil},
    {name = 'DeviceId', is_array = false, struct = nil}, {name = 'Level', is_array = false, struct = nil}
}

function TSetCoolingDeviceLevelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceId', self.DeviceId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Level', self.Level, 'uint8', false, errs, need_convert)

    TSetCoolingDeviceLevelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCoolingDeviceLevelReq.proto_property, errs, need_convert)
    return self
end

function TSetCoolingDeviceLevelReq:unpack(_)
    return self.ManufactureId, self.DeviceType, self.DeviceId, self.Level
end

SetCoolingDeviceLevel.SetCoolingDeviceLevelReq = TSetCoolingDeviceLevelReq

---@class ThermalMgmtIpmiCmds.SetCoolingDeviceLevelRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetCoolingDeviceLevelRsp = {}
TSetCoolingDeviceLevelRsp.__index = TSetCoolingDeviceLevelRsp
TSetCoolingDeviceLevelRsp.group = {}

local function TSetCoolingDeviceLevelRsp_from_obj(obj)
    return setmetatable(obj, TSetCoolingDeviceLevelRsp)
end

function TSetCoolingDeviceLevelRsp.new(CompletionCode, ManufactureId)
    return TSetCoolingDeviceLevelRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj ThermalMgmtIpmiCmds.SetCoolingDeviceLevelRsp
function TSetCoolingDeviceLevelRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetCoolingDeviceLevelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCoolingDeviceLevelRsp.group)
end

TSetCoolingDeviceLevelRsp.from_obj = TSetCoolingDeviceLevelRsp_from_obj

TSetCoolingDeviceLevelRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetCoolingDeviceLevelRsp.default = {0, 0}

TSetCoolingDeviceLevelRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetCoolingDeviceLevelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetCoolingDeviceLevelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCoolingDeviceLevelRsp.proto_property, errs, need_convert)
    return self
end

function TSetCoolingDeviceLevelRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetCoolingDeviceLevel.SetCoolingDeviceLevelRsp = TSetCoolingDeviceLevelRsp

return SetCoolingDeviceLevel
