--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetFanCtlMode = {}

---@class ThermalMgmtIpmiCmds.GetFanCtlModeReq
---@field ManufactureId integer
local TGetFanCtlModeReq = {}
TGetFanCtlModeReq.__index = TGetFanCtlModeReq
TGetFanCtlModeReq.group = {}

local function TGetFanCtlModeReq_from_obj(obj)
    return setmetatable(obj, TGetFanCtlModeReq)
end

function TGetFanCtlModeReq.new(ManufactureId)
    return TGetFanCtlModeReq_from_obj({ManufactureId = ManufactureId})
end
---@param obj ThermalMgmtIpmiCmds.GetFanCtlModeReq
function TGetFanCtlModeReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
end

function TGetFanCtlModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFanCtlModeReq.group)
end

TGetFanCtlModeReq.from_obj = TGetFanCtlModeReq_from_obj

TGetFanCtlModeReq.proto_property = {'ManufactureId'}

TGetFanCtlModeReq.default = {0}

TGetFanCtlModeReq.struct = {{name = 'ManufactureId', is_array = false, struct = nil}}

function TGetFanCtlModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TGetFanCtlModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFanCtlModeReq.proto_property, errs, need_convert)
    return self
end

function TGetFanCtlModeReq:unpack(_)
    return self.ManufactureId
end

GetFanCtlMode.GetFanCtlModeReq = TGetFanCtlModeReq

---@class ThermalMgmtIpmiCmds.GetFanCtlModeRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Mode integer
---@field Timeout string
local TGetFanCtlModeRsp = {}
TGetFanCtlModeRsp.__index = TGetFanCtlModeRsp
TGetFanCtlModeRsp.group = {}

local function TGetFanCtlModeRsp_from_obj(obj)
    return setmetatable(obj, TGetFanCtlModeRsp)
end

function TGetFanCtlModeRsp.new(CompletionCode, ManufactureId, Mode, Timeout)
    return TGetFanCtlModeRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Mode = Mode,
        Timeout = Timeout
    })
end
---@param obj ThermalMgmtIpmiCmds.GetFanCtlModeRsp
function TGetFanCtlModeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Mode = obj.Mode
    self.Timeout = obj.Timeout
end

function TGetFanCtlModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFanCtlModeRsp.group)
end

TGetFanCtlModeRsp.from_obj = TGetFanCtlModeRsp_from_obj

TGetFanCtlModeRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Mode', 'Timeout'}

TGetFanCtlModeRsp.default = {0, 0, 0, ''}

TGetFanCtlModeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Mode', is_array = false, struct = nil}, {name = 'Timeout', is_array = false, struct = nil}
}

function TGetFanCtlModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Mode', self.Mode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Timeout', self.Timeout, 'string', false, errs, need_convert)

    TGetFanCtlModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFanCtlModeRsp.proto_property, errs, need_convert)
    return self
end

function TGetFanCtlModeRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Mode, self.Timeout
end

GetFanCtlMode.GetFanCtlModeRsp = TGetFanCtlModeRsp

return GetFanCtlMode
