-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-5-29
-- Description: DO NOT EDIT; Code generated by "service.lua.mako"
local mdb = require 'mc.mdb'
local class = require 'mc.class'
local object_manage = require 'mc.mdb.object_manage'

local PidConfigurationTypes = require 'debug.json_types.PidConfiguration'
local PropertiesTypes = require 'debug.json_types.Properties'

local ThermalMgmtDebug = mdb.register_object('/bmc/kepler/Debug/ThermalMgmt', {
    {name = 'bmc.kepler.Debug.PidConfiguration', interface = PidConfigurationTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function ThermalMgmtDebug:ctor()
    self.path = '/bmc/kepler/Debug/ThermalMgmt'
end

local model = require 'debug.class.model'

local thermal_mgmt_service = class()

thermal_mgmt_service.package = 'thermal_mgmt'

function thermal_mgmt_service:CreateThermalMgmtDebug(prop_setting_cb)
    return object_manage.create_object('ThermalMgmtDebug', 'ThermalMgmtDebug_0', '/bmc/kepler/Debug/ThermalMgmt',
        prop_setting_cb)
end

function thermal_mgmt_service:ImplThermalMgmtDebugPidConfigurationGetVersion(cb)
    model.ImplThermalMgmtDebugPidConfigurationGetVersion(cb)
end

function thermal_mgmt_service:ImplThermalMgmtDebugPidConfigurationSetPidPrintMode(cb)
    model.ImplThermalMgmtDebugPidConfigurationSetPidPrintMode(cb)
end

function thermal_mgmt_service:ImplThermalMgmtDebugPidConfigurationSetPidConfigItem(cb)
    model.ImplThermalMgmtDebugPidConfigurationSetPidConfigItem(cb)
end

function thermal_mgmt_service:ImplThermalMgmtDebugPropertiesGetOptions(cb)
    model.ImplThermalMgmtDebugPropertiesGetOptions(cb)
end

function thermal_mgmt_service:ImplThermalMgmtDebugPropertiesGetPropertiesByOptions(cb)
    model.ImplThermalMgmtDebugPropertiesGetPropertiesByOptions(cb)
end

function thermal_mgmt_service:get_bus()
    return self.bus
end

function thermal_mgmt_service:ctor(bus)
    self.bus = bus
    self.signal_slots = {}
    self.name = self.name or thermal_mgmt_service.package

    model.init(self.bus)
    thermal_mgmt_service.bus = self.bus
end

function thermal_mgmt_service:init()
end

return thermal_mgmt_service
