-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local create_enum_type = require 'mc.enum'

local def_types = {}

---@class def_types.PolicyType: Enum
local EPolicyType = create_enum_type('PolicyType')
EPolicyType.default = EPolicyType.new(2147483647)
EPolicyType.struct = nil
EPolicyType.InletCustom = EPolicyType.new(1)
EPolicyType.DiskCustom = EPolicyType.new(2)
EPolicyType.InvalidType = EPolicyType.new(4294967295)

def_types.PolicyType = EPolicyType

---@class def_types.TemperatureType: Enum
local ETemperatureType = create_enum_type('TemperatureType')
ETemperatureType.default = ETemperatureType.new(2147483647)
ETemperatureType.struct = nil
ETemperatureType.Cpu = ETemperatureType.new(1)
ETemperatureType.Outlet = ETemperatureType.new(2)
ETemperatureType.Disk = ETemperatureType.new(3)
ETemperatureType.Memory = ETemperatureType.new(4)
ETemperatureType.PCH = ETemperatureType.new(5)
ETemperatureType.VRD = ETemperatureType.new(6)
ETemperatureType.VDDQ = ETemperatureType.new(7)
ETemperatureType.NPUHbm = ETemperatureType.new(8)
ETemperatureType.NPUAiCore = ETemperatureType.new(9)
ETemperatureType.NPUBoard = ETemperatureType.new(10)
ETemperatureType.Inlet = ETemperatureType.new(11)
ETemperatureType.SoCBoardOutlet = ETemperatureType.new(12)
ETemperatureType.SoCBoardInlet = ETemperatureType.new(13)
ETemperatureType.InvalidType = ETemperatureType.new(4294967295)

def_types.TemperatureType = ETemperatureType

return def_types
