-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPWMChannel = {}

---@class MPWMChannel.ManageFans
---@field ManageFans integer[]
local TManageFans = {}
TManageFans.__index = TManageFans
TManageFans.group = {}

local function TManageFans_from_obj(obj)
    return setmetatable(obj, TManageFans)
end

function TManageFans.new(ManageFans)
    return TManageFans_from_obj({ManageFans = ManageFans})
end
---@param obj MPWMChannel.ManageFans
function TManageFans:init_from_obj(obj)
    self.ManageFans = obj.ManageFans
end

function TManageFans:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManageFans.group)
end

TManageFans.from_obj = TManageFans_from_obj

TManageFans.proto_property = {'ManageFans'}

TManageFans.default = {{}}

TManageFans.struct = {{name = 'ManageFans', is_array = true, struct = nil}}

function TManageFans:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'ManageFans', self.ManageFans, 'uint8', false, errs, need_convert)

    TManageFans:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManageFans.proto_property, errs, need_convert)
    return self
end

function TManageFans:unpack(_)
    return self.ManageFans
end

MPWMChannel.ManageFans = TManageFans

---@class MPWMChannel.PWMChannelObjectName
---@field PWMChannelObjectName string
local TPWMChannelObjectName = {}
TPWMChannelObjectName.__index = TPWMChannelObjectName
TPWMChannelObjectName.group = {}

local function TPWMChannelObjectName_from_obj(obj)
    return setmetatable(obj, TPWMChannelObjectName)
end

function TPWMChannelObjectName.new(PWMChannelObjectName)
    return TPWMChannelObjectName_from_obj({PWMChannelObjectName = PWMChannelObjectName})
end
---@param obj MPWMChannel.PWMChannelObjectName
function TPWMChannelObjectName:init_from_obj(obj)
    self.PWMChannelObjectName = obj.PWMChannelObjectName
end

function TPWMChannelObjectName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPWMChannelObjectName.group)
end

TPWMChannelObjectName.from_obj = TPWMChannelObjectName_from_obj

TPWMChannelObjectName.proto_property = {'PWMChannelObjectName'}

TPWMChannelObjectName.default = {''}

TPWMChannelObjectName.struct = {{name = 'PWMChannelObjectName', is_array = false, struct = nil}}

function TPWMChannelObjectName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'PWMChannelObjectName', self.PWMChannelObjectName, 'string', false, errs, need_convert)

    TPWMChannelObjectName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPWMChannelObjectName.proto_property, errs, need_convert)
    return self
end

function TPWMChannelObjectName:unpack(_)
    return self.PWMChannelObjectName
end

MPWMChannel.PWMChannelObjectName = TPWMChannelObjectName

return MPWMChannel
