-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MLiquidCoolingConfig = {}

---@class MLiquidCoolingConfig.MaxPumpNum
---@field MaxPumpNum integer
local TMaxPumpNum = {}
TMaxPumpNum.__index = TMaxPumpNum
TMaxPumpNum.group = {}

local function TMaxPumpNum_from_obj(obj)
    return setmetatable(obj, TMaxPumpNum)
end

function TMaxPumpNum.new(MaxPumpNum)
    return TMaxPumpNum_from_obj({MaxPumpNum = MaxPumpNum or 0})
end
---@param obj MLiquidCoolingConfig.MaxPumpNum
function TMaxPumpNum:init_from_obj(obj)
    self.MaxPumpNum = obj.MaxPumpNum or 0
end

function TMaxPumpNum:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxPumpNum.group)
end

TMaxPumpNum.from_obj = TMaxPumpNum_from_obj

TMaxPumpNum.proto_property = {'MaxPumpNum'}

TMaxPumpNum.default = {0}

TMaxPumpNum.struct = {{name = 'MaxPumpNum', is_array = false, struct = nil}}

function TMaxPumpNum:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxPumpNum', self.MaxPumpNum, 'uint8', false, errs, need_convert)

    TMaxPumpNum:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxPumpNum.proto_property, errs, need_convert)
    return self
end

function TMaxPumpNum:unpack(_)
    return self.MaxPumpNum
end

MLiquidCoolingConfig.MaxPumpNum = TMaxPumpNum

return MLiquidCoolingConfig
