-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MFanInfo = {}

---@class MFanInfo.IsTwins
---@field IsTwins boolean
local TIsTwins = {}
TIsTwins.__index = TIsTwins
TIsTwins.group = {}

local function TIsTwins_from_obj(obj)
    return setmetatable(obj, TIsTwins)
end

function TIsTwins.new(IsTwins)
    return TIsTwins_from_obj({IsTwins = IsTwins or false})
end
---@param obj MFanInfo.IsTwins
function TIsTwins:init_from_obj(obj)
    self.IsTwins = obj.IsTwins or false
end

function TIsTwins:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsTwins.group)
end

TIsTwins.from_obj = TIsTwins_from_obj

TIsTwins.proto_property = {'IsTwins'}

TIsTwins.default = {false}

TIsTwins.struct = {{name = 'IsTwins', is_array = false, struct = nil}}

function TIsTwins:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsTwins', self.IsTwins, 'bool', false, errs, need_convert)

    TIsTwins:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsTwins.proto_property, errs, need_convert)
    return self
end

function TIsTwins:unpack(_)
    return self.IsTwins
end

MFanInfo.IsTwins = TIsTwins

---@class MFanInfo.RearMaxSpeed
---@field RearMaxSpeed integer
local TRearMaxSpeed = {}
TRearMaxSpeed.__index = TRearMaxSpeed
TRearMaxSpeed.group = {}

local function TRearMaxSpeed_from_obj(obj)
    return setmetatable(obj, TRearMaxSpeed)
end

function TRearMaxSpeed.new(RearMaxSpeed)
    return TRearMaxSpeed_from_obj({RearMaxSpeed = RearMaxSpeed or 10000})
end
---@param obj MFanInfo.RearMaxSpeed
function TRearMaxSpeed:init_from_obj(obj)
    self.RearMaxSpeed = obj.RearMaxSpeed or 10000
end

function TRearMaxSpeed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRearMaxSpeed.group)
end

TRearMaxSpeed.from_obj = TRearMaxSpeed_from_obj

TRearMaxSpeed.proto_property = {'RearMaxSpeed'}

TRearMaxSpeed.default = {0}

TRearMaxSpeed.struct = {{name = 'RearMaxSpeed', is_array = false, struct = nil}}

function TRearMaxSpeed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RearMaxSpeed', self.RearMaxSpeed, 'uint32', false, errs, need_convert)

    TRearMaxSpeed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRearMaxSpeed.proto_property, errs, need_convert)
    return self
end

function TRearMaxSpeed:unpack(_)
    return self.RearMaxSpeed
end

MFanInfo.RearMaxSpeed = TRearMaxSpeed

---@class MFanInfo.FrontMaxSpeed
---@field FrontMaxSpeed integer
local TFrontMaxSpeed = {}
TFrontMaxSpeed.__index = TFrontMaxSpeed
TFrontMaxSpeed.group = {}

local function TFrontMaxSpeed_from_obj(obj)
    return setmetatable(obj, TFrontMaxSpeed)
end

function TFrontMaxSpeed.new(FrontMaxSpeed)
    return TFrontMaxSpeed_from_obj({FrontMaxSpeed = FrontMaxSpeed or 10000})
end
---@param obj MFanInfo.FrontMaxSpeed
function TFrontMaxSpeed:init_from_obj(obj)
    self.FrontMaxSpeed = obj.FrontMaxSpeed or 10000
end

function TFrontMaxSpeed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFrontMaxSpeed.group)
end

TFrontMaxSpeed.from_obj = TFrontMaxSpeed_from_obj

TFrontMaxSpeed.proto_property = {'FrontMaxSpeed'}

TFrontMaxSpeed.default = {0}

TFrontMaxSpeed.struct = {{name = 'FrontMaxSpeed', is_array = false, struct = nil}}

function TFrontMaxSpeed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FrontMaxSpeed', self.FrontMaxSpeed, 'uint32', false, errs, need_convert)

    TFrontMaxSpeed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFrontMaxSpeed.proto_property, errs, need_convert)
    return self
end

function TFrontMaxSpeed:unpack(_)
    return self.FrontMaxSpeed
end

MFanInfo.FrontMaxSpeed = TFrontMaxSpeed

---@class MFanInfo.PartNumber
---@field PartNumber string
local TPartNumber = {}
TPartNumber.__index = TPartNumber
TPartNumber.group = {}

local function TPartNumber_from_obj(obj)
    return setmetatable(obj, TPartNumber)
end

function TPartNumber.new(PartNumber)
    return TPartNumber_from_obj({PartNumber = PartNumber or [=[NA]=]})
end
---@param obj MFanInfo.PartNumber
function TPartNumber:init_from_obj(obj)
    self.PartNumber = obj.PartNumber or [=[NA]=]
end

function TPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPartNumber.group)
end

TPartNumber.from_obj = TPartNumber_from_obj

TPartNumber.proto_property = {'PartNumber'}

TPartNumber.default = {''}

TPartNumber.struct = {{name = 'PartNumber', is_array = false, struct = nil}}

function TPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PartNumber', self.PartNumber, 'string', false, errs, need_convert)

    TPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPartNumber.proto_property, errs, need_convert)
    return self
end

function TPartNumber:unpack(_)
    return self.PartNumber
end

MFanInfo.PartNumber = TPartNumber

---@class MFanInfo.BOM
---@field BOM string
local TBOM = {}
TBOM.__index = TBOM
TBOM.group = {}

local function TBOM_from_obj(obj)
    return setmetatable(obj, TBOM)
end

function TBOM.new(BOM)
    return TBOM_from_obj({BOM = BOM or [=[NA]=]})
end
---@param obj MFanInfo.BOM
function TBOM:init_from_obj(obj)
    self.BOM = obj.BOM or [=[NA]=]
end

function TBOM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBOM.group)
end

TBOM.from_obj = TBOM_from_obj

TBOM.proto_property = {'BOM'}

TBOM.default = {''}

TBOM.struct = {{name = 'BOM', is_array = false, struct = nil}}

function TBOM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BOM', self.BOM, 'string', false, errs, need_convert)

    TBOM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBOM.proto_property, errs, need_convert)
    return self
end

function TBOM:unpack(_)
    return self.BOM
end

MFanInfo.BOM = TBOM

---@class MFanInfo.Model
---@field Model string
local TModel = {}
TModel.__index = TModel
TModel.group = {}

local function TModel_from_obj(obj)
    return setmetatable(obj, TModel)
end

function TModel.new(Model)
    return TModel_from_obj({Model = Model or [=[]=]})
end
---@param obj MFanInfo.Model
function TModel:init_from_obj(obj)
    self.Model = obj.Model or [=[]=]
end

function TModel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModel.group)
end

TModel.from_obj = TModel_from_obj

TModel.proto_property = {'Model'}

TModel.default = {''}

TModel.struct = {{name = 'Model', is_array = false, struct = nil}}

function TModel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Model', self.Model, 'string', false, errs, need_convert)

    TModel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModel.proto_property, errs, need_convert)
    return self
end

function TModel:unpack(_)
    return self.Model
end

MFanInfo.Model = TModel

---@class MFanInfo.Type
---@field Type integer
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type or 0})
end
---@param obj MFanInfo.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type or 0
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {0}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

MFanInfo.Type = TType

---@class MFanInfo.FanPosition
---@field FanPosition string
local TFanPosition = {}
TFanPosition.__index = TFanPosition
TFanPosition.group = {}

local function TFanPosition_from_obj(obj)
    return setmetatable(obj, TFanPosition)
end

function TFanPosition.new(FanPosition)
    return TFanPosition_from_obj({FanPosition = FanPosition or [=[]=]})
end
---@param obj MFanInfo.FanPosition
function TFanPosition:init_from_obj(obj)
    self.FanPosition = obj.FanPosition or [=[]=]
end

function TFanPosition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanPosition.group)
end

TFanPosition.from_obj = TFanPosition_from_obj

TFanPosition.proto_property = {'FanPosition'}

TFanPosition.default = {''}

TFanPosition.struct = {{name = 'FanPosition', is_array = false, struct = nil}}

function TFanPosition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'FanPosition', self.FanPosition, 'string', false, errs, need_convert)

    TFanPosition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanPosition.proto_property, errs, need_convert)
    return self
end

function TFanPosition:unpack(_)
    return self.FanPosition
end

MFanInfo.FanPosition = TFanPosition

---@class MFanInfo.SystemId
---@field SystemId integer
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj)
    return setmetatable(obj, TSystemId)
end

function TSystemId.new(SystemId)
    return TSystemId_from_obj({SystemId = SystemId or 0})
end
---@param obj MFanInfo.SystemId
function TSystemId:init_from_obj(obj)
    self.SystemId = obj.SystemId or 0
end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {0}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs, need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs, need_convert)
    return self
end

function TSystemId:unpack(_)
    return self.SystemId
end

MFanInfo.SystemId = TSystemId

---@class MFanInfo.FanId
---@field FanId integer
local TFanId = {}
TFanId.__index = TFanId
TFanId.group = {}

local function TFanId_from_obj(obj)
    return setmetatable(obj, TFanId)
end

function TFanId.new(FanId)
    return TFanId_from_obj({FanId = FanId or 0})
end
---@param obj MFanInfo.FanId
function TFanId:init_from_obj(obj)
    self.FanId = obj.FanId or 0
end

function TFanId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanId.group)
end

TFanId.from_obj = TFanId_from_obj

TFanId.proto_property = {'FanId'}

TFanId.default = {0}

TFanId.struct = {{name = 'FanId', is_array = false, struct = nil}}

function TFanId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'FanId', self.FanId, 'uint16', false, errs, need_convert)

    TFanId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanId.proto_property, errs, need_convert)
    return self
end

function TFanId:unpack(_)
    return self.FanId
end

MFanInfo.FanId = TFanId

return MFanInfo
