-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MFan = {}

---@class MFan.IdentifyStatus
---@field IdentifyStatus integer
local TIdentifyStatus = {}
TIdentifyStatus.__index = TIdentifyStatus
TIdentifyStatus.group = {}

local function TIdentifyStatus_from_obj(obj)
    return setmetatable(obj, TIdentifyStatus)
end

function TIdentifyStatus.new(IdentifyStatus)
    return TIdentifyStatus_from_obj({IdentifyStatus = IdentifyStatus or 0})
end
---@param obj MFan.IdentifyStatus
function TIdentifyStatus:init_from_obj(obj)
    self.IdentifyStatus = obj.IdentifyStatus or 0
end

function TIdentifyStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIdentifyStatus.group)
end

TIdentifyStatus.from_obj = TIdentifyStatus_from_obj

TIdentifyStatus.proto_property = {'IdentifyStatus'}

TIdentifyStatus.default = {0}

TIdentifyStatus.struct = {{name = 'IdentifyStatus', is_array = false, struct = nil}}

function TIdentifyStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IdentifyStatus', self.IdentifyStatus, 'uint8', false, errs, need_convert)

    TIdentifyStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIdentifyStatus.proto_property, errs, need_convert)
    return self
end

function TIdentifyStatus:unpack(_)
    return self.IdentifyStatus
end

MFan.IdentifyStatus = TIdentifyStatus

---@class MFan.SingleConnector
---@field SingleConnector integer[]
local TSingleConnector = {}
TSingleConnector.__index = TSingleConnector
TSingleConnector.group = {}

local function TSingleConnector_from_obj(obj)
    return setmetatable(obj, TSingleConnector)
end

function TSingleConnector.new(SingleConnector)
    return TSingleConnector_from_obj({SingleConnector = SingleConnector})
end
---@param obj MFan.SingleConnector
function TSingleConnector:init_from_obj(obj)
    self.SingleConnector = obj.SingleConnector
end

function TSingleConnector:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSingleConnector.group)
end

TSingleConnector.from_obj = TSingleConnector_from_obj

TSingleConnector.proto_property = {'SingleConnector'}

TSingleConnector.default = {{}}

TSingleConnector.struct = {{name = 'SingleConnector', is_array = true, struct = nil}}

function TSingleConnector:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SingleConnector', self.SingleConnector, 'uint8', false, errs, need_convert)

    TSingleConnector:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSingleConnector.proto_property, errs, need_convert)
    return self
end

function TSingleConnector:unpack(_)
    return self.SingleConnector
end

MFan.SingleConnector = TSingleConnector

---@class MFan.DualConnector
---@field DualConnector integer[]
local TDualConnector = {}
TDualConnector.__index = TDualConnector
TDualConnector.group = {}

local function TDualConnector_from_obj(obj)
    return setmetatable(obj, TDualConnector)
end

function TDualConnector.new(DualConnector)
    return TDualConnector_from_obj({DualConnector = DualConnector})
end
---@param obj MFan.DualConnector
function TDualConnector:init_from_obj(obj)
    self.DualConnector = obj.DualConnector
end

function TDualConnector:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDualConnector.group)
end

TDualConnector.from_obj = TDualConnector_from_obj

TDualConnector.proto_property = {'DualConnector'}

TDualConnector.default = {{}}

TDualConnector.struct = {{name = 'DualConnector', is_array = true, struct = nil}}

function TDualConnector:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'DualConnector', self.DualConnector, 'uint8', false, errs, need_convert)

    TDualConnector:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDualConnector.proto_property, errs, need_convert)
    return self
end

function TDualConnector:unpack(_)
    return self.DualConnector
end

MFan.DualConnector = TDualConnector

---@class MFan.PowerGood
---@field PowerGood integer
local TPowerGood = {}
TPowerGood.__index = TPowerGood
TPowerGood.group = {}

local function TPowerGood_from_obj(obj)
    return setmetatable(obj, TPowerGood)
end

function TPowerGood.new(PowerGood)
    return TPowerGood_from_obj({PowerGood = PowerGood})
end
---@param obj MFan.PowerGood
function TPowerGood:init_from_obj(obj)
    self.PowerGood = obj.PowerGood
end

function TPowerGood:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerGood.group)
end

TPowerGood.from_obj = TPowerGood_from_obj

TPowerGood.proto_property = {'PowerGood'}

TPowerGood.default = {0}

TPowerGood.struct = {{name = 'PowerGood', is_array = false, struct = nil}}

function TPowerGood:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerGood', self.PowerGood, 'uint8', false, errs, need_convert)

    TPowerGood:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerGood.proto_property, errs, need_convert)
    return self
end

function TPowerGood:unpack(_)
    return self.PowerGood
end

MFan.PowerGood = TPowerGood

---@class MFan.FanObjectName
---@field FanObjectName string
local TFanObjectName = {}
TFanObjectName.__index = TFanObjectName
TFanObjectName.group = {}

local function TFanObjectName_from_obj(obj)
    return setmetatable(obj, TFanObjectName)
end

function TFanObjectName.new(FanObjectName)
    return TFanObjectName_from_obj({FanObjectName = FanObjectName})
end
---@param obj MFan.FanObjectName
function TFanObjectName:init_from_obj(obj)
    self.FanObjectName = obj.FanObjectName
end

function TFanObjectName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanObjectName.group)
end

TFanObjectName.from_obj = TFanObjectName_from_obj

TFanObjectName.proto_property = {'FanObjectName'}

TFanObjectName.default = {''}

TFanObjectName.struct = {{name = 'FanObjectName', is_array = false, struct = nil}}

function TFanObjectName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'FanObjectName', self.FanObjectName, 'string', false, errs, need_convert)

    TFanObjectName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanObjectName.proto_property, errs, need_convert)
    return self
end

function TFanObjectName:unpack(_)
    return self.FanObjectName
end

MFan.FanObjectName = TFanObjectName

return MFan
