-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MCoolingPolicy = {}

---@class MCoolingPolicy.OriginSpeedRangeHigh
---@field OriginSpeedRangeHigh integer[]
local TOriginSpeedRangeHigh = {}
TOriginSpeedRangeHigh.__index = TOriginSpeedRangeHigh
TOriginSpeedRangeHigh.group = {}

local function TOriginSpeedRangeHigh_from_obj(obj)
    return setmetatable(obj, TOriginSpeedRangeHigh)
end

function TOriginSpeedRangeHigh.new(OriginSpeedRangeHigh)
    return TOriginSpeedRangeHigh_from_obj({OriginSpeedRangeHigh = OriginSpeedRangeHigh})
end
---@param obj MCoolingPolicy.OriginSpeedRangeHigh
function TOriginSpeedRangeHigh:init_from_obj(obj)
    self.OriginSpeedRangeHigh = obj.OriginSpeedRangeHigh
end

function TOriginSpeedRangeHigh:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOriginSpeedRangeHigh.group)
end

TOriginSpeedRangeHigh.from_obj = TOriginSpeedRangeHigh_from_obj

TOriginSpeedRangeHigh.proto_property = {'OriginSpeedRangeHigh'}

TOriginSpeedRangeHigh.default = {{}}

TOriginSpeedRangeHigh.struct = {{name = 'OriginSpeedRangeHigh', is_array = true, struct = nil}}

function TOriginSpeedRangeHigh:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'OriginSpeedRangeHigh', self.OriginSpeedRangeHigh, 'int16', false, errs,
        need_convert)

    TOriginSpeedRangeHigh:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOriginSpeedRangeHigh.proto_property, errs, need_convert)
    return self
end

function TOriginSpeedRangeHigh:unpack(_)
    return self.OriginSpeedRangeHigh
end

MCoolingPolicy.OriginSpeedRangeHigh = TOriginSpeedRangeHigh

---@class MCoolingPolicy.OriginSpeedRangeLow
---@field OriginSpeedRangeLow integer[]
local TOriginSpeedRangeLow = {}
TOriginSpeedRangeLow.__index = TOriginSpeedRangeLow
TOriginSpeedRangeLow.group = {}

local function TOriginSpeedRangeLow_from_obj(obj)
    return setmetatable(obj, TOriginSpeedRangeLow)
end

function TOriginSpeedRangeLow.new(OriginSpeedRangeLow)
    return TOriginSpeedRangeLow_from_obj({OriginSpeedRangeLow = OriginSpeedRangeLow})
end
---@param obj MCoolingPolicy.OriginSpeedRangeLow
function TOriginSpeedRangeLow:init_from_obj(obj)
    self.OriginSpeedRangeLow = obj.OriginSpeedRangeLow
end

function TOriginSpeedRangeLow:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOriginSpeedRangeLow.group)
end

TOriginSpeedRangeLow.from_obj = TOriginSpeedRangeLow_from_obj

TOriginSpeedRangeLow.proto_property = {'OriginSpeedRangeLow'}

TOriginSpeedRangeLow.default = {{}}

TOriginSpeedRangeLow.struct = {{name = 'OriginSpeedRangeLow', is_array = true, struct = nil}}

function TOriginSpeedRangeLow:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'OriginSpeedRangeLow', self.OriginSpeedRangeLow, 'int16',
        false, errs, need_convert)

    TOriginSpeedRangeLow:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOriginSpeedRangeLow.proto_property, errs, need_convert)
    return self
end

function TOriginSpeedRangeLow:unpack(_)
    return self.OriginSpeedRangeLow
end

MCoolingPolicy.OriginSpeedRangeLow = TOriginSpeedRangeLow

---@class MCoolingPolicy.OriginTemperatureRangeHigh
---@field OriginTemperatureRangeHigh integer[]
local TOriginTemperatureRangeHigh = {}
TOriginTemperatureRangeHigh.__index = TOriginTemperatureRangeHigh
TOriginTemperatureRangeHigh.group = {}

local function TOriginTemperatureRangeHigh_from_obj(obj)
    return setmetatable(obj, TOriginTemperatureRangeHigh)
end

function TOriginTemperatureRangeHigh.new(OriginTemperatureRangeHigh)
    return TOriginTemperatureRangeHigh_from_obj({OriginTemperatureRangeHigh = OriginTemperatureRangeHigh})
end
---@param obj MCoolingPolicy.OriginTemperatureRangeHigh
function TOriginTemperatureRangeHigh:init_from_obj(obj)
    self.OriginTemperatureRangeHigh = obj.OriginTemperatureRangeHigh
end

function TOriginTemperatureRangeHigh:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOriginTemperatureRangeHigh.group)
end

TOriginTemperatureRangeHigh.from_obj = TOriginTemperatureRangeHigh_from_obj

TOriginTemperatureRangeHigh.proto_property = {'OriginTemperatureRangeHigh'}

TOriginTemperatureRangeHigh.default = {{}}

TOriginTemperatureRangeHigh.struct = {{name = 'OriginTemperatureRangeHigh', is_array = true, struct = nil}}

function TOriginTemperatureRangeHigh:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'OriginTemperatureRangeHigh', self.OriginTemperatureRangeHigh, 'int16', false,
        errs, need_convert)

    TOriginTemperatureRangeHigh:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOriginTemperatureRangeHigh.proto_property, errs, need_convert)
    return self
end

function TOriginTemperatureRangeHigh:unpack(_)
    return self.OriginTemperatureRangeHigh
end

MCoolingPolicy.OriginTemperatureRangeHigh = TOriginTemperatureRangeHigh

---@class MCoolingPolicy.OriginTemperatureRangeLow
---@field OriginTemperatureRangeLow integer[]
local TOriginTemperatureRangeLow = {}
TOriginTemperatureRangeLow.__index = TOriginTemperatureRangeLow
TOriginTemperatureRangeLow.group = {}

local function TOriginTemperatureRangeLow_from_obj(obj)
    return setmetatable(obj, TOriginTemperatureRangeLow)
end

function TOriginTemperatureRangeLow.new(OriginTemperatureRangeLow)
    return TOriginTemperatureRangeLow_from_obj({OriginTemperatureRangeLow = OriginTemperatureRangeLow})
end
---@param obj MCoolingPolicy.OriginTemperatureRangeLow
function TOriginTemperatureRangeLow:init_from_obj(obj)
    self.OriginTemperatureRangeLow = obj.OriginTemperatureRangeLow
end

function TOriginTemperatureRangeLow:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOriginTemperatureRangeLow.group)
end

TOriginTemperatureRangeLow.from_obj = TOriginTemperatureRangeLow_from_obj

TOriginTemperatureRangeLow.proto_property = {'OriginTemperatureRangeLow'}

TOriginTemperatureRangeLow.default = {{}}

TOriginTemperatureRangeLow.struct = {{name = 'OriginTemperatureRangeLow', is_array = true, struct = nil}}

function TOriginTemperatureRangeLow:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'OriginTemperatureRangeLow', self.OriginTemperatureRangeLow, 'int16', false, errs,
        need_convert)

    TOriginTemperatureRangeLow:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOriginTemperatureRangeLow.proto_property, errs, need_convert)
    return self
end

function TOriginTemperatureRangeLow:unpack(_)
    return self.OriginTemperatureRangeLow
end

MCoolingPolicy.OriginTemperatureRangeLow = TOriginTemperatureRangeLow

---@class MCoolingPolicy.CoolingMedium
---@field CoolingMedium string
local TCoolingMedium = {}
TCoolingMedium.__index = TCoolingMedium
TCoolingMedium.group = {}

local function TCoolingMedium_from_obj(obj)
    return setmetatable(obj, TCoolingMedium)
end

function TCoolingMedium.new(CoolingMedium)
    return TCoolingMedium_from_obj({CoolingMedium = CoolingMedium or [=[Air]=]})
end
---@param obj MCoolingPolicy.CoolingMedium
function TCoolingMedium:init_from_obj(obj)
    self.CoolingMedium = obj.CoolingMedium or [=[Air]=]
end

function TCoolingMedium:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCoolingMedium.group)
end

TCoolingMedium.from_obj = TCoolingMedium_from_obj

TCoolingMedium.proto_property = {'CoolingMedium'}

TCoolingMedium.default = {''}

TCoolingMedium.struct = {{name = 'CoolingMedium', is_array = false, struct = nil}}

function TCoolingMedium:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CoolingMedium', self.CoolingMedium, 'string', false, errs, need_convert)

    if self.CoolingMedium ~= nil then
        validate.regex(prefix .. 'CoolingMedium', self.CoolingMedium, [=[^(Air|Liquid)$]=], errs, need_convert)
    end

    TCoolingMedium:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCoolingMedium.proto_property, errs, need_convert)
    return self
end

function TCoolingMedium:unpack(_)
    return self.CoolingMedium
end

MCoolingPolicy.CoolingMedium = TCoolingMedium

---@class MCoolingPolicy.PCIeCardName
---@field PCIeCardName string[]
local TPCIeCardName = {}
TPCIeCardName.__index = TPCIeCardName
TPCIeCardName.group = {}

local function TPCIeCardName_from_obj(obj)
    return setmetatable(obj, TPCIeCardName)
end

function TPCIeCardName.new(PCIeCardName)
    return TPCIeCardName_from_obj({PCIeCardName = PCIeCardName})
end
---@param obj MCoolingPolicy.PCIeCardName
function TPCIeCardName:init_from_obj(obj)
    self.PCIeCardName = obj.PCIeCardName
end

function TPCIeCardName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPCIeCardName.group)
end

TPCIeCardName.from_obj = TPCIeCardName_from_obj

TPCIeCardName.proto_property = {'PCIeCardName'}

TPCIeCardName.default = {{}}

TPCIeCardName.struct = {{name = 'PCIeCardName', is_array = true, struct = nil}}

function TPCIeCardName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'PCIeCardName', self.PCIeCardName, 'string', false, errs, need_convert)

    TPCIeCardName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPCIeCardName.proto_property, errs, need_convert)
    return self
end

function TPCIeCardName:unpack(_)
    return self.PCIeCardName
end

MCoolingPolicy.PCIeCardName = TPCIeCardName

---@class MCoolingPolicy.HDDBackPlaneType
---@field HDDBackPlaneType string
local THDDBackPlaneType = {}
THDDBackPlaneType.__index = THDDBackPlaneType
THDDBackPlaneType.group = {}

local function THDDBackPlaneType_from_obj(obj)
    return setmetatable(obj, THDDBackPlaneType)
end

function THDDBackPlaneType.new(HDDBackPlaneType)
    return THDDBackPlaneType_from_obj({HDDBackPlaneType = HDDBackPlaneType})
end
---@param obj MCoolingPolicy.HDDBackPlaneType
function THDDBackPlaneType:init_from_obj(obj)
    self.HDDBackPlaneType = obj.HDDBackPlaneType
end

function THDDBackPlaneType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THDDBackPlaneType.group)
end

THDDBackPlaneType.from_obj = THDDBackPlaneType_from_obj

THDDBackPlaneType.proto_property = {'HDDBackPlaneType'}

THDDBackPlaneType.default = {''}

THDDBackPlaneType.struct = {{name = 'HDDBackPlaneType', is_array = false, struct = nil}}

function THDDBackPlaneType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HDDBackPlaneType', self.HDDBackPlaneType, 'string', false, errs, need_convert)

    if self.HDDBackPlaneType ~= nil then
        validate.regex(prefix .. 'HDDBackPlaneType', self.HDDBackPlaneType,
            [=[^(FrontPosition|MiddlePosition|RearPosition)$]=], errs, need_convert)
    end

    THDDBackPlaneType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THDDBackPlaneType.proto_property, errs, need_convert)
    return self
end

function THDDBackPlaneType:unpack(_)
    return self.HDDBackPlaneType
end

MCoolingPolicy.HDDBackPlaneType = THDDBackPlaneType

---@class MCoolingPolicy.HDDRearBackPlaneName
---@field HDDRearBackPlaneName string[]
local THDDRearBackPlaneName = {}
THDDRearBackPlaneName.__index = THDDRearBackPlaneName
THDDRearBackPlaneName.group = {}

local function THDDRearBackPlaneName_from_obj(obj)
    return setmetatable(obj, THDDRearBackPlaneName)
end

function THDDRearBackPlaneName.new(HDDRearBackPlaneName)
    return THDDRearBackPlaneName_from_obj({HDDRearBackPlaneName = HDDRearBackPlaneName})
end
---@param obj MCoolingPolicy.HDDRearBackPlaneName
function THDDRearBackPlaneName:init_from_obj(obj)
    self.HDDRearBackPlaneName = obj.HDDRearBackPlaneName
end

function THDDRearBackPlaneName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THDDRearBackPlaneName.group)
end

THDDRearBackPlaneName.from_obj = THDDRearBackPlaneName_from_obj

THDDRearBackPlaneName.proto_property = {'HDDRearBackPlaneName'}

THDDRearBackPlaneName.default = {{}}

THDDRearBackPlaneName.struct = {{name = 'HDDRearBackPlaneName', is_array = true, struct = nil}}

function THDDRearBackPlaneName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'HDDRearBackPlaneName', self.HDDRearBackPlaneName, 'string', false, errs,
        need_convert)

    THDDRearBackPlaneName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THDDRearBackPlaneName.proto_property, errs, need_convert)
    return self
end

function THDDRearBackPlaneName:unpack(_)
    return self.HDDRearBackPlaneName
end

MCoolingPolicy.HDDRearBackPlaneName = THDDRearBackPlaneName

---@class MCoolingPolicy.HDDBackPlaneName
---@field HDDBackPlaneName string[]
local THDDBackPlaneName = {}
THDDBackPlaneName.__index = THDDBackPlaneName
THDDBackPlaneName.group = {}

local function THDDBackPlaneName_from_obj(obj)
    return setmetatable(obj, THDDBackPlaneName)
end

function THDDBackPlaneName.new(HDDBackPlaneName)
    return THDDBackPlaneName_from_obj({HDDBackPlaneName = HDDBackPlaneName})
end
---@param obj MCoolingPolicy.HDDBackPlaneName
function THDDBackPlaneName:init_from_obj(obj)
    self.HDDBackPlaneName = obj.HDDBackPlaneName
end

function THDDBackPlaneName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THDDBackPlaneName.group)
end

THDDBackPlaneName.from_obj = THDDBackPlaneName_from_obj

THDDBackPlaneName.proto_property = {'HDDBackPlaneName'}

THDDBackPlaneName.default = {{}}

THDDBackPlaneName.struct = {{name = 'HDDBackPlaneName', is_array = true, struct = nil}}

function THDDBackPlaneName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'HDDBackPlaneName', self.HDDBackPlaneName, 'string', false, errs, need_convert)

    THDDBackPlaneName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THDDBackPlaneName.proto_property, errs, need_convert)
    return self
end

function THDDBackPlaneName:unpack(_)
    return self.HDDBackPlaneName
end

MCoolingPolicy.HDDBackPlaneName = THDDBackPlaneName

---@class MCoolingPolicy.DiskTempUnavailableToValid
---@field DiskTempUnavailableToValid boolean
local TDiskTempUnavailableToValid = {}
TDiskTempUnavailableToValid.__index = TDiskTempUnavailableToValid
TDiskTempUnavailableToValid.group = {}

local function TDiskTempUnavailableToValid_from_obj(obj)
    return setmetatable(obj, TDiskTempUnavailableToValid)
end

function TDiskTempUnavailableToValid.new(DiskTempUnavailableToValid)
    return TDiskTempUnavailableToValid_from_obj({DiskTempUnavailableToValid = DiskTempUnavailableToValid})
end
---@param obj MCoolingPolicy.DiskTempUnavailableToValid
function TDiskTempUnavailableToValid:init_from_obj(obj)
    self.DiskTempUnavailableToValid = obj.DiskTempUnavailableToValid
end

function TDiskTempUnavailableToValid:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDiskTempUnavailableToValid.group)
end

TDiskTempUnavailableToValid.from_obj = TDiskTempUnavailableToValid_from_obj

TDiskTempUnavailableToValid.proto_property = {'DiskTempUnavailableToValid'}

TDiskTempUnavailableToValid.default = {false}

TDiskTempUnavailableToValid.struct = {{name = 'DiskTempUnavailableToValid', is_array = false, struct = nil}}

function TDiskTempUnavailableToValid:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DiskTempUnavailableToValid', self.DiskTempUnavailableToValid, 'bool', false, errs,
        need_convert)

    TDiskTempUnavailableToValid:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDiskTempUnavailableToValid.proto_property, errs, need_convert)
    return self
end

function TDiskTempUnavailableToValid:unpack(_)
    return self.DiskTempUnavailableToValid
end

MCoolingPolicy.DiskTempUnavailableToValid = TDiskTempUnavailableToValid

---@class MCoolingPolicy.FanType
---@field FanType string[]
local TFanType = {}
TFanType.__index = TFanType
TFanType.group = {}

local function TFanType_from_obj(obj)
    return setmetatable(obj, TFanType)
end

function TFanType.new(FanType)
    return TFanType_from_obj({FanType = FanType})
end
---@param obj MCoolingPolicy.FanType
function TFanType:init_from_obj(obj)
    self.FanType = obj.FanType
end

function TFanType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanType.group)
end

TFanType.from_obj = TFanType_from_obj

TFanType.proto_property = {'FanType'}

TFanType.default = {{}}

TFanType.struct = {{name = 'FanType', is_array = true, struct = nil}}

function TFanType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'FanType', self.FanType, 'string', false, errs, need_convert)

    TFanType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanType.proto_property, errs, need_convert)
    return self
end

function TFanType:unpack(_)
    return self.FanType
end

MCoolingPolicy.FanType = TFanType

---@class MCoolingPolicy.FanSpeedArray
---@field FanSpeedArray string
local TFanSpeedArray = {}
TFanSpeedArray.__index = TFanSpeedArray
TFanSpeedArray.group = {}

local function TFanSpeedArray_from_obj(obj)
    return setmetatable(obj, TFanSpeedArray)
end

function TFanSpeedArray.new(FanSpeedArray)
    return TFanSpeedArray_from_obj({FanSpeedArray = FanSpeedArray})
end
---@param obj MCoolingPolicy.FanSpeedArray
function TFanSpeedArray:init_from_obj(obj)
    self.FanSpeedArray = obj.FanSpeedArray
end

function TFanSpeedArray:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanSpeedArray.group)
end

TFanSpeedArray.from_obj = TFanSpeedArray_from_obj

TFanSpeedArray.proto_property = {'FanSpeedArray'}

TFanSpeedArray.default = {''}

TFanSpeedArray.struct = {{name = 'FanSpeedArray', is_array = false, struct = nil}}

function TFanSpeedArray:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FanSpeedArray', self.FanSpeedArray, 'string', false, errs, need_convert)

    TFanSpeedArray:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanSpeedArray.proto_property, errs, need_convert)
    return self
end

function TFanSpeedArray:unpack(_)
    return self.FanSpeedArray
end

MCoolingPolicy.FanSpeedArray = TFanSpeedArray

---@class MCoolingPolicy.TemperatureArray
---@field TemperatureArray string
local TTemperatureArray = {}
TTemperatureArray.__index = TTemperatureArray
TTemperatureArray.group = {}

local function TTemperatureArray_from_obj(obj)
    return setmetatable(obj, TTemperatureArray)
end

function TTemperatureArray.new(TemperatureArray)
    return TTemperatureArray_from_obj({TemperatureArray = TemperatureArray})
end
---@param obj MCoolingPolicy.TemperatureArray
function TTemperatureArray:init_from_obj(obj)
    self.TemperatureArray = obj.TemperatureArray
end

function TTemperatureArray:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureArray.group)
end

TTemperatureArray.from_obj = TTemperatureArray_from_obj

TTemperatureArray.proto_property = {'TemperatureArray'}

TTemperatureArray.default = {''}

TTemperatureArray.struct = {{name = 'TemperatureArray', is_array = false, struct = nil}}

function TTemperatureArray:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureArray', self.TemperatureArray, 'string', false, errs, need_convert)

    TTemperatureArray:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureArray.proto_property, errs, need_convert)
    return self
end

function TTemperatureArray:unpack(_)
    return self.TemperatureArray
end

MCoolingPolicy.TemperatureArray = TTemperatureArray

return MCoolingPolicy
