-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MCoolingArea = {}

---@class MCoolingArea.Priority
---@field Priority integer
local TPriority = {}
TPriority.__index = TPriority
TPriority.group = {}

local function TPriority_from_obj(obj)
    return setmetatable(obj, TPriority)
end

function TPriority.new(Priority)
    return TPriority_from_obj({Priority = Priority or 1})
end
---@param obj MCoolingArea.Priority
function TPriority:init_from_obj(obj)
    self.Priority = obj.Priority or 1
end

function TPriority:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPriority.group)
end

TPriority.from_obj = TPriority_from_obj

TPriority.proto_property = {'Priority'}

TPriority.default = {0}

TPriority.struct = {{name = 'Priority', is_array = false, struct = nil}}

function TPriority:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Priority', self.Priority, 'uint8', false, errs, need_convert)

    TPriority:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPriority.proto_property, errs, need_convert)
    return self
end

function TPriority:unpack(_)
    return self.Priority
end

MCoolingArea.Priority = TPriority

---@class MCoolingArea.LiquidCoolingDeviceGroup
---@field LiquidCoolingDeviceGroup integer[]
local TLiquidCoolingDeviceGroup = {}
TLiquidCoolingDeviceGroup.__index = TLiquidCoolingDeviceGroup
TLiquidCoolingDeviceGroup.group = {}

local function TLiquidCoolingDeviceGroup_from_obj(obj)
    return setmetatable(obj, TLiquidCoolingDeviceGroup)
end

function TLiquidCoolingDeviceGroup.new(LiquidCoolingDeviceGroup)
    return TLiquidCoolingDeviceGroup_from_obj({LiquidCoolingDeviceGroup = LiquidCoolingDeviceGroup or {}})
end
---@param obj MCoolingArea.LiquidCoolingDeviceGroup
function TLiquidCoolingDeviceGroup:init_from_obj(obj)
    self.LiquidCoolingDeviceGroup = obj.LiquidCoolingDeviceGroup or {}
end

function TLiquidCoolingDeviceGroup:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLiquidCoolingDeviceGroup.group)
end

TLiquidCoolingDeviceGroup.from_obj = TLiquidCoolingDeviceGroup_from_obj

TLiquidCoolingDeviceGroup.proto_property = {'LiquidCoolingDeviceGroup'}

TLiquidCoolingDeviceGroup.default = {{}}

TLiquidCoolingDeviceGroup.struct = {{name = 'LiquidCoolingDeviceGroup', is_array = true, struct = nil}}

function TLiquidCoolingDeviceGroup:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'LiquidCoolingDeviceGroup', self.LiquidCoolingDeviceGroup, 'uint8', false, errs,
        need_convert)

    TLiquidCoolingDeviceGroup:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLiquidCoolingDeviceGroup.proto_property, errs, need_convert)
    return self
end

function TLiquidCoolingDeviceGroup:unpack(_)
    return self.LiquidCoolingDeviceGroup
end

MCoolingArea.LiquidCoolingDeviceGroup = TLiquidCoolingDeviceGroup

return MCoolingArea
