## 1、功能简介
thermal_mgmt负责散热器件管理，提供散热器件状态监测、调速、异常告警和资产信息收集与展示的功能。


## 2、关键特性
### 2.1 风扇特性
#### 2.1.1 风扇型号识别
通过对风扇槽位、转速、是否为双转子的筛选对风速型号进行唯一类别的判断。

#### 2.1.2 单双转子识别
根据单双转子在位识别，提供设置转子类型混插告警的功能。在刷新风扇转速是否稳定时，支持前、后转子最大转速区间内的稳定告警。

#### 2.1.3 风扇转速管理
支持风扇批量转速管理与单风扇转速管理。批量转速管理提供对所有风扇PWM值批量下发与查询的能力。单风扇调速支持对单个风扇的转速管理。支持查询风扇转速的功能。

#### 2.1.4 风扇状态监测
风扇状态监测包含状态异常、风扇类型混插监测的能力。

#### 2.1.5 风扇信息收集与展示
在Web风扇&散热界面与一键收集日志fan_info.txt、thermal_info.txt中可查看风扇槽位号、名称、型号、转速、速率比以及部件编码等信息。


### 2.2 液冷泵特性
#### 2.2.1 液冷泵转速管理
支持液冷泵批量转速管理，提供对所有液冷泵PWM值批量下发与查询的能力。

#### 2.2.2 液冷泵状态监测
液冷泵状态监测，包括液冷泵正常状态、异常转速、是否在位、与停转监测的能力。

#### 2.2.3 液冷泵信息收集与展示
在Web风扇&散热界面可查看LAAC泵转速、速率比与部件编码信息。


### 2.3 关断阀特性
#### 2.3.1 关断阀基础信息
支持关断阀硬件基础信息的查询，包括槽位号、在位状态、开度、标定开度、开度状态。

#### 2.3.2 关断阀开度值管理
在关断阀巡检时，会对关断阀设置目标开度值并对下发的值进行误差检验，最后将检验结果更新为开度值状态。支持查询、设置开度值。

#### 2.3.3 关断阀巡检
支持巡检信息的查询，包括关断阀巡检类型、巡检结果、巡检状态、最后一次巡检时间。提供两种巡检方式，分别是不巡检与例行巡检（仅支持月度巡检）。月度巡检会对关断阀进行批量读值，以定期监控阀的健康状况，记录日志，并上报网管。


## 3、对外接口
### 3.1 资源树属性

1. Fan

<table>
	<tr>
	    <th>Object(path)</th>
	    <th>interface</th>
	    <th>method/property/signal</th> 
        <th>Type</th>
        <th>取值类型</th> 
        <th>备注</th> 
	</tr >
	<tr >
	    <td rowspan="32">/bmc/kepler/Systems/:SystemId/Thermal/Fans/:Id</td>
	    <td rowspan="32">bmc.kepler.Systems.Fan</td>
	    <td>FanId</td>
        <td>property</td>
        <td>U16</td>
        <td>风扇ID</td>
	</tr>
	<tr>
	    <td>Slot</td>
	    <td>property</td>
        <td>U8</td>
        <td>风扇槽位</td>
	</tr>
	<tr>
	    <td>Type</td>
	    <td>property</td>
        <td>U8</td>
        <td>风扇类型</td>
	</tr>
	<tr>
	    <td>Model</td>
	    <td>property</td>
        <td>String</td>
        <td>风扇类型</td>
	</tr>
    <tr>
	    <td>Coefficient</td>
	    <td>property</td>
        <td>U8</td>
        <td>风扇转速系数</td>
	</tr>
    <tr>
	    <td>FanHealth</td>
	    <td>property</td>
        <td>U8</td>
        <td>风扇健康</td>
	</tr>
    <tr>
	    <td>FanEntity</td>
	    <td>property</td>
        <td>String</td>
        <td>风扇实例</td>
	</tr>
    <tr>
	    <td>FrontPresence</td>
	    <td>property</td>
        <td>U8</td>
        <td>前风扇在位</td>
	</tr>
    <tr>
	    <td>RearPresence</td>
	    <td>property</td>
        <td>U8</td>
        <td>后风扇在位</td>
	</tr>
    <tr>
	    <td>FrontSpeed</td>
	    <td>property</td>
        <td>U16</td>
        <td>前风扇转速</td>
	</tr>
    <tr>
	    <td>RearSpeed</td>
	    <td>property</td>
        <td>U16</td>
        <td>后风扇转速</td>
	</tr>
    <tr>
	    <td>FrontStatus</td>
	    <td>property</td>
        <td>U8</td>
        <td>前风扇状态</td>
	</tr>
	<tr>
	    <td>RearStatus</td>
	    <td>property</td>
        <td>U8</td>
        <td>后风扇状态</td>
	</tr>
	<tr>
	    <td>FrontRPM</td>
	    <td>property</td>
        <td>U16</td>
        <td>前泵转速</td>
	</tr>
    <tr>
	    <td>RearRPM</td>
	    <td>property</td>
        <td>U16</td>
        <td>后泵转速</td>
	</tr>
    <tr>
	    <td>HardwarePWM</td>
	    <td>property</td>
        <td>Double</td>
        <td>硬件转速百分比</td>
	</tr>
    <tr>
	    <td>PWMPercentage</td>
	    <td>property</td>
        <td>U32</td>
        <td>转速百分比</td>
	</tr>
    <tr>
	    <td>ExpectedPWM</td>
	    <td>property</td>
        <td>Double</td>
        <td>预期转速百分比</td>
	</tr>
    <tr>
	    <td>FanAlarmLed</td>
	    <td>property</td>
        <td>U8</td>
        <td>风扇告警</td>
	</tr>
    <tr>
	    <td>BOM</td>
	    <td>property</td>
        <td>String</td>
        <td>BOM编码</td>
	</tr>
    <tr>
	    <td>SystemId</td>
	    <td>property</td>
        <td>U8</td>
        <td>系统Id</td>
	</tr>
    <tr>
	    <td>MaxSupportedPWM</td>
	    <td>property</td>
        <td>U32</td>
        <td>最大支持转速</td>
	</tr>
	<tr>
	    <td>IdentifySpeedLevel</td>
	    <td>property</td>
        <td>U8</td>
        <td>识别风速级别</td>
	</tr>
	<tr>
	    <td>PartNumber</td>
	    <td>property</td>
        <td>String</td>
        <td>部件号</td>
	</tr>
    <tr>
	    <td>FrontMaxSpeed</td>
	    <td>property</td>
        <td>U32</td>
        <td>前转子最大转速</td>
	</tr>
    <tr>
	    <td>RearMaxSpeed</td>
	    <td>property</td>
        <td>U32</td>
        <td>后转子最大转速</td>
	</tr>
    <tr>
	    <td>IsTwins</td>
	    <td>property</td>
        <td>Boolean</td>
        <td>是否为单双转子</td>
	</tr>
    <tr>
	    <td>Position</td>
	    <td>property</td>
        <td>String</td>
        <td>容器信息</td>
	</tr>
    <tr>
	    <td>FunctionDesc</td>
	    <td>property</td>
        <td>String</td>
        <td>功能描述</td>
	</tr>
    <tr>
	    <td>DeviceName</td>
	    <td>property</td>
        <td>String</td>
        <td>部件名称</td>
	</tr>
    <tr>
	    <td>SpeedStable</td>
	    <td>property</td>
        <td>Boolean</td>
        <td>风扇转速是否稳定（true:稳定，false:不稳定）,<br>期望转速与实际转速比相差25%以内为稳定</td>
	</tr>
</table>

2. Pump

<table>
	<tr>
	    <th>Object(path)</th>
	    <th>interface</th>
	    <th>method/property/signal</th> 
        <th>Type</th>
        <th>取值类型</th> 
        <th>备注</th> 
	</tr >
	<tr >
	    <td rowspan="11">/bmc/kepler/Systems/:SystemId/Thermal/Pumps/:Id</td>
	    <td rowspan="11">bmc.kepler.Systems.Pump</td>
	    <td>Id</td>
        <td>property</td>
        <td>U16</td>
        <td>泵Id</td>
	</tr>
	<tr>
	    <td>Slot</td>
	    <td>property</td>
        <td>U8</td>
        <td>槽位</td>
	</tr>
	<tr>
	    <td>Model</td>
	    <td>property</td>
        <td>String</td>
        <td>型号</td>
	</tr>
	<tr>
	    <td>ExpectedPWM</td>
	    <td>property</td>
        <td>Double</td>
        <td>预期的PWM值</td>
	</tr>
    <tr>
	    <td>ActualPWM</td>
	    <td>property</td>
        <td>Double</td>
        <td>实际PWM值</td>
	</tr>
    <tr>
	    <td>MaxSupportedPWM</td>
	    <td>property</td>
        <td>U32</td>
        <td>泵全速额定PWM值</td>
	</tr>
    <tr>
	    <td>SpeedRPM</td>
	    <td>property</td>
        <td>U16</td>
        <td>泵转速(转/分钟）</td>
	</tr>
    <tr>
	    <td>Presence</td>
	    <td>property</td>
        <td>U8</td>
        <td>在位信息：1在位，0不在位</td>
	</tr>
    <tr>
	    <td>Status</td>
	    <td>property</td>
        <td>U8</td>
        <td>泵状态</td>
	</tr>
    <tr>
	    <td>MaxSpeedRPM</td>
	    <td>property</td>
        <td>U32</td>
        <td>泵全速额定转速(转/分钟）</td>
	</tr>
    <tr>
	    <td>PartNumber</td>
	    <td>property</td>
        <td>String</td>
        <td>部件号</td>
	</tr>
</table>

3. Fans

<table>
	<tr>
	    <th>Object(path)</th>
	    <th>interface</th>
	    <th>method/property/signal</th> 
        <th>Type</th>
        <th>取值类型</th> 
        <th>备注</th> 
	</tr >
	<tr >
	    <td rowspan="2">/bmc/kepler/Systems/:SystemId/Thermal/Fans</td>
	    <td rowspan="2">bmc.kepler.Systems.Fans</td>
	    <td>SetPWM</td>
        <td>method</td>
        <td>Double[]</td>
        <td>设置所有风扇转速</td>
    </tr>
    <tr>
	    <td>WorkInStandby</td>
	    <td>property</td>
        <td>U8</td>
        <td>standby下风扇是否可以运转</td>
	</tr>
</table>

4. Pumps

<table>
	<tr>
	    <th>Object(path)</th>
	    <th>interface</th>
	    <th>method/property/signal</th> 
        <th>Type</th>
        <th>取值类型</th> 
        <th>备注</th> 
	</tr >
	<tr >
	    <td rowspan="2">/bmc/kepler/Systems/:SystemId/Thermal/Pumps</td>
	    <td rowspan="2">bmc.kepler.Systems.Pumps</td>
        <td>WorkInStandby</td>
	    <td>property</td>
        <td>U8</td>
        <td>standby下是否可以运转</td>
	</tr>
    <tr>
        <td>SetPWM</td>
        <td>method</td>
        <td>Double[]</td>
        <td>设置所有泵转速</td>
	</tr>
</table>

5. Valves

<table>
	<tr>
	    <th>Object(path)</th>
	    <th>interface</th>
	    <th>method/property/signal</th> 
        <th>Type</th>
        <th>取值类型</th> 
        <th>备注</th> 
	</tr >
	<tr >
	    <td rowspan="3">/bmc/kepler/Chassis/:ChassisId/Thermal/Valves</td>
	    <td rowspan="3">bmc.kepler.Chassis.Valves</td>
	    <td>StartPatrol</td>
        <td>method</td>
        <td>U32</td>
        <td>启动关断阀巡检</td>
	</tr>
    <tr>
	    <td>PatrolState</td>
	    <td>property</td>
        <td>String</td>
        <td>巡检状态</td>
	</tr>
    <tr>
	    <td>LastPatrolTimestamp</td>
	    <td>property</td>
        <td>U32</td>
        <td>最近一次巡检时间</td>
	</tr>
</table>

6. Valve

<table>
	<tr>
	    <th>Object(path)</th>
	    <th>interface</th>
	    <th>method/property/signal</th> 
        <th>Type</th>
        <th>取值类型</th> 
        <th>备注</th> 
	</tr >
	<tr >
	    <td rowspan="8">/bmc/kepler/Chassis/:ChassisId/Thermal/Valves/:Id</td>
	    <td rowspan="8">bmc.kepler.Chassis.Valve</td>
	    <td>Id</td>
        <td>property</td>
        <td>U8</td>
        <td>关断阀Id</td>
	</tr>
    <tr>
	    <td>Slot</td>
	    <td>property</td>
        <td>U8</td>
        <td>关断阀槽位</td>
	</tr>
    <tr>
	    <td>Presence</td>
	    <td>property</td>
        <td>U8</td>
        <td>关断阀在位。1在位，0不在位</td>
	</tr>
    <tr>
	    <td>Status</td>
	    <td>property</td>
        <td>U16</td>
        <td>关断阀故障状态: 0-正常, 非0-关断阀故障</td>
	</tr>
    <tr>
	    <td>OpeningDegreeState</td>
	    <td>property</td>
        <td>U8</td>
        <td>关断阀开度状态:0-正常, 1-异常</td>
	</tr>
    <tr>
	    <td>PatrolResult</td>
	    <td>property</td>
        <td>U8</td>
        <td>关断阀巡检结果: 0-成功, 1-失败</td>
	</tr>
    <tr>
	    <td>OpeningDegree</td>
	    <td>property</td>
        <td>U32</td>
        <td>关断阀开度</td>
	</tr>
    <tr>
	    <td>StandardOpeningDegree</td>
	    <td>property</td>
        <td>U32</td>
        <td>关断阀标称开度</td>
	</tr>
</table>