-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local rpc_service_subhealth = require 'rpc_services.rpc_service_subhealth'
local skynet = require 'skynet'


local function construct_ctx()
    local ctx = {}
    ctx.ChanType = 1
    ctx.get_initiator = function()
        return {}
    end

    return ctx
end

local function create_drive(self)
    local drive_info = { HddBackplaneStartSlot = 0, Presence = 1, RelativeSlot = 1, ObjectName = 'Drive1', Id = 1 }
    self.object_manager.mc:add_object('Drive', drive_info)
    self.bus_monitor_service.on_os_state_changed:emit(true)
    local drive = self.drive_collection:get_drive(drive_info.Name)
    return drive_info, drive
end

-- 测试手动获取硬盘日志信息
function TestStorage:test_start_collect_log_temp()
    local _, drive = create_drive(self)
    local ctx = construct_ctx()
    drive.Name = 'Disk1'
    self.drive_collection.get_all_drives = function ()
        return {drive}
    end
    skynet.fork_once = function(cb, ...)
        return cb(...)
    end
    rpc_service_subhealth.log_collect_status = {
        global = false,
        drives = {}
    }
    
    local ok, _ = pcall(rpc_service_subhealth.start_collect_log, rpc_service_subhealth, ctx, 'Disk1')
    lu.assertEquals(ok, true)
    ok = pcall(rpc_service_subhealth.start_collect_log, rpc_service_subhealth, ctx, '*')
    lu.assertEquals(ok, true)


    -- 模拟已经开始收集所有日志
    rpc_service_subhealth.log_collect_status.global = true
    ok = pcall(rpc_service_subhealth.start_collect_log, rpc_service_subhealth, ctx, '*')
    lu.assertEquals(ok, true)
    ok = pcall(rpc_service_subhealth.start_collect_log, rpc_service_subhealth, ctx, 'Disk1')
    lu.assertEquals(ok, true)

    -- 模拟已经开始收集单个日志
    rpc_service_subhealth.log_collect_status.global = false
    rpc_service_subhealth.log_collect_status.drives = {["Disk1"] = true}
    ok = pcall(rpc_service_subhealth.start_collect_log, rpc_service_subhealth, ctx, '*')
    lu.assertEquals(ok, true)
    ok = pcall(rpc_service_subhealth.start_collect_log, rpc_service_subhealth, ctx, 'Disk1')
    lu.assertEquals(ok, true)
end