-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local c_handler_base = require 'bma.handles.handler_base'
local lu = require 'luaunit'

TestBMAHandlerBase = {}
function TestBMAHandlerBase:setupClass()
end

function TestBMAHandlerBase:teardownClass()
end

function TestBMAHandlerBase:test_regist_object()
    local self_ = { resources = {}, objects = {} }
    local path = 'test'
    c_handler_base.regist_object(self_, path, nil, {})
    lu.assertEquals(self_.resources[path][1], false)
    self_.on_need_update = {
        emit = function()
        end,
    }
    c_handler_base.match_resource(self_, {})
    c_handler_base.regist_object(self_, path, {}, {})
    lu.assertEquals(self_.resources[path][1], true)
end

function TestBMAHandlerBase:test_match_objects()
    local path = '/test/'
    local self_ = {
        resources = {
            [path] = { true, true }
        },
        objects = {}
    }

    local res = c_handler_base.match_object(self_, path, {})
    lu.assertEquals(res, true)
    self_.resources[path] = { false, { 'test_var' } }
    self_.find_object = function()
        return {}
    end
    self_.regist_object = function()
        return {}
    end
    res = c_handler_base.match_object(self_, path, {})
    lu.assertEquals(res, {})
end

return TestBMAHandlerBase