-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

loadfile(os.getenv('CONFIG_FILE'), 't', { package = package, os = os })()
package.path = '../../gen/storage/?.lua;' .. package.path

local utils = require 'utils.core'
local logging = require 'mc.logging'
local current_file_dir = debug.getinfo(1).source:match('@?(.*)/')
utils.chdir(current_file_dir)
logging:setPrint(nil)
logging:setLevel(logging.INFO)

local lu = require('luaunit')

require 'test_common'
-- require 'test_controller'
-- require 'test_array'
-- require 'test_drive'
-- require 'test_pd_identify'
require 'test_sml'
-- require 'test_volume'
-- require 'test_controller_ccheck'
-- require 'test_battery'
require 'test_nvme_mi_protocol'
-- require 'test_bma.test_handler_pass_through_drive'
require 'test_mdb_object'
require 'test_set_fault_indicator_state'
require 'test_error_engine'
require 'test_nvme'
-- require 'test_storage_app'
require 'test_method_misc'
require 'test_bma.test_handler_base'

-- 仅用于通过门禁，后续不需要该用例，由test_battery.lua实现
require 'test_battery_init'

-- 仅用于通过门禁，后续不需要该用例，由test_drive.lua实现
require 'test_rpc_sevice_subhealth'

os.exit(lu.LuaUnit.run())
