-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local sdbus = require 'sd_bus'
local app_base = require 'mc.app_base'
local PCIeBinding = require 'storage.json_types.PCIe'

return function(work)
    local mdb_app = app_base.new('Mdb')
    local mctpd_app = app_base.new('mctpd')
    local is_exit = false

    local bus = sdbus.open_user(true, true)
    bus:request_name(mdb_app.service_name)
    local vtbl = sdbus.new_vtable(mdb_app.app_path, mdb_app.app_interface)
    vtbl:add_method('GetObject', 'sas', 'a{sas}', function(path, interfaces)
        if path == '/bmc/kepler/Systems/1/Mctp' and interfaces[1] == PCIeBinding.interface.interface then
            return {[mctpd_app.service_name] = {PCIeBinding.interface.interface}}
        end

        return {}
    end)
    vtbl:add_method('exit', '', '', function()
        is_exit = true
    end)
    bus:regist_vtable(vtbl)

    bus.bus:run_until(function()
        return false
    end, 100)

    work:recv()
    work:recv()

    bus.bus:run_until(function()
        return is_exit
    end, 500000)
end
