-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local bs = require 'mc.bitstring'

local types = {}

types.t_ctrl_properties = bs.new([[<<
    copyback_enabled:1,
    smarter_copyback_enabled:1,
    jbod_enabled:1,
    _:29
>>]])

types.c_ctrl_operations = bs.new([[<<
    support_jbod:1,
    support_jbod_state:1,
    support_mode_set:1,
    support_raid:1,
    support_hba:1,
    support_mixed:1,
    support_epd:1,
    configured_drive_wcp:2,
    unconfigured_drive_wcp:2,
    hba_drive_wcp:2,
    _:19
>>]])

types.t_ld_operations = bs.new([[<<
    support_read_policy:1,
    support_write_policy:1,
    support_io_policy:1,
    support_access_policy:1,
    support_disk_cache_policy:1,
    default_write_policy:2,
    _:25
>>]])

types.t_pd_operations = bs.new([[<<
    support_temperature:1,
    support_crypto_erase:1,
    _:30
>>]])

types.t_support_ld_operations = bs.new([[<<
    o_support_read_policy:1,
    o_support_write_policy:1,
    o_support_io_policy:1,
    o_support_access_policy:1,
    o_support_disk_cache_policy:1,
    o_default_write_policy:2,
    _:25
>>]])

types.t_support_pd_operations = bs.new([[<<
    o_support_temperature:1,
    o_support_crypto_erase:1,
    _:30
>>]])

types.t_support_ctrl_operations = bs.new([[<<
    o_support_raid0:1,
    o_support_raid1:1,
    o_support_raid5:1,
    o_support_raid6:1,
    o_support_raid10:1,
    o_support_raid50:1,
    o_support_raid60:1,
    o_support_raid1adm:1,
    o_support_raid10adm:1,
    o_support_raid1triple:1,
    o_support_raid10triple:1,
    o_support_jbod_state:1,
    o_support_mode_set:1,
    o_support_raid:1,
    o_support_hba:1,
    o_support_jbod:1,
    o_support_mixed:1,
    o_support_epd:1,
    o_configured_drive_wcp:2,
    o_unconfigured_drive_wcp:2,
    o_hba_drive_wcp:2,
    _:8
>>]])

types.interface_type_map = {
    [0] = 'SPI',
    [1] = 'SAS 3G',
    [2] = 'SATA 1.5G',
    [3] = 'SATA 3G',
    [4] = 'SAS 6G',
    [5] = 'SAS 12G',
    [6] = 'SAS 32G',
    [7] = 'SAS 64G',
    [8] = 'SATA 32G',
    [9] = 'SATA 64G'
}

types.level_array = {
    'RAID0', 'RAID1', 'RAID5', 'RAID6', 'RAID10', 'RAID50', 'RAID60', 'RAID1(ADM)', 'RAID10(ADM)',
    'RAID1Triple', 'RAID10Triple'
}

return types
