-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local utils = require 'mc.utils'
-- pd_log_data_s
---@class pd_log_data_s
---@field result integer
---@field scsi_status_code integer
---@field data_length integer
---@field data lightuserdata

-- sata_devices
---@class t_sata_devices
---@field smart_attribute pd_log_data_s
---@field smart_attribute_threshold pd_log_data_s
---@field error pd_log_data_s
---@field extent_error pd_log_data_s
---@field extended_selftest pd_log_data_s
---@field phy_event pd_log_data_s
---@field seagate_glist pd_log_data_s
---@field seagate_plist pd_log_data_s
---@field seagate_critical_event pd_log_data_s
---@field seagate_farm pd_log_data_s

-- sas_devices
---@class t_sas_devices
---@field selftest pd_log_data_s
---@field read_error_cnt pd_log_data_s
---@field write_error_cnt pd_log_data_s
---@field verify_error_cnt pd_log_data_s
---@field nonmedium_error_cnt pd_log_data_s
---@field phy_error_cnt pd_log_data_s
---@field glist pd_log_data_s
---@field ie pd_log_data_s
---@field bms pd_log_data_s
---@field general_statistics pd_log_data_s
---@field huawei_specific32h pd_log_data_s
---@field huawei_specific34h pd_log_data_s
---@field huawei_specific35h pd_log_data_s
---@field huawei_io_info pd_log_data_s
---@field kioxia_ssd_specific pd_log_data_s
---@field kioxia_eopt pd_log_data_s
---@field kioxia_smart_data pd_log_data_s


-- pd_log_info
---@class pd_log_info
---@field sata_devices t_sata_devices
---@field sas_devices t_sas_devices
local pd_log_info = {}
pd_log_info.__index = pd_log_info

local pd_log_data = {
    result = 0,
    scsi_status_code = 0,
    data_length = 0,
    data = nil
}

local pd_log = {
    sata_devices = {
        smart_attribute = utils.table_copy(pd_log_data),
        smart_attribute_threshold = utils.table_copy(pd_log_data),
        error = utils.table_copy(pd_log_data),
        extent_error = utils.table_copy(pd_log_data),
        extended_selftest = utils.table_copy(pd_log_data),
        phy_event = utils.table_copy(pd_log_data),
        seagate_glist = utils.table_copy(pd_log_data),
        seagate_plist = utils.table_copy(pd_log_data),
        seagate_critical_event = utils.table_copy(pd_log_data),
        seagate_farm = utils.table_copy(pd_log_data)
    },
    sas_devices = {
        selftest = utils.table_copy(pd_log_data),
        read_error_cnt = utils.table_copy(pd_log_data),
        write_error_cnt = utils.table_copy(pd_log_data),
        verify_error_cnt = utils.table_copy(pd_log_data),
        nonmedium_error_cnt = utils.table_copy(pd_log_data),
        phy_error_cnt = utils.table_copy(pd_log_data),
        glist = utils.table_copy(pd_log_data),
        ie = utils.table_copy(pd_log_data),
        bms = utils.table_copy(pd_log_data),
        general_statistics = utils.table_copy(pd_log_data),
        huawei_specific32h = utils.table_copy(pd_log_data),
        huawei_specific34h = utils.table_copy(pd_log_data),
        huawei_specific35h = utils.table_copy(pd_log_data),
        huawei_io_info = utils.table_copy(pd_log_data),
        kioxia_ssd_specific = utils.table_copy(pd_log_data),
        kioxia_eopt = utils.table_copy(pd_log_data),
        kioxia_smart_data = utils.table_copy(pd_log_data)
    }
}

function pd_log_info.new()
    return setmetatable(pd_log, pd_log_info)
end

return pd_log_info
